### R code from vignette source 'GrpSeqBnds-vignette.Rnw'
### Encoding: UTF-8

###################################################
### code chunk number 1: PwrGSDpd
###################################################
options(keep.source = TRUE, width = 70)
PwrGSDpd <- packageDescription("PwrGSD")
library(PwrGSD)


###################################################
### code chunk number 2: var-ratios
###################################################
    frac    <- c(0.006995655, 0.01444565, 0.02682463, 0.04641363, 0.0585665,
                 0.07614902, 0.1135391, 0.168252, 0.2336901, 0.3186155, 0.4164776,
                 0.5352199, 0.670739, 0.8246061, 1)


###################################################
### code chunk number 3: event-ratios
###################################################
    frac.ii <- c(0.1494354, 0.1972965, 0.2625075, 0.3274323, 0.3519184, 0.40231,
                 0.4673037, 0.5579035, 0.6080742, 0.6982293, 0.7671917, 0.8195019,
                 0.9045182, 0.9515884, 1)


###################################################
### code chunk number 4: drift
###################################################
    drift <-   c(0.06214444, 0.1061856, 0.1731267, 0.2641265, 0.3105231, 0.3836636,
                 0.5117394, 0.6918584, 0.8657705, 1.091984, 1.311094, 1.538582,
                 1.818346, 2.081775, 2.345386)


###################################################
### code chunk number 5: example-1
###################################################
    example.1 <- GrpSeqBnds(frac=frac, 
                            EfficacyBoundary=LanDemets(alpha=0.05, spending=ObrienFleming))


###################################################
### code chunk number 6: ex1-plot
###################################################
    plot(example.1)


###################################################
### code chunk number 7: incl-ex1-plot
###################################################
    plot(example.1)


###################################################
### code chunk number 8: example-2
###################################################
    example.2 <- GrpSeqBnds(frac=frac,  
                            EfficacyBoundary=LanDemets(alpha=0.05, spending=ObrienFleming),
                            FutilityBoundary=LanDemets(alpha=0.10, spending=ObrienFleming),
                            drift=drift)
    SimGSB(example.2)


###################################################
### code chunk number 9: ex2-plot
###################################################
  plot(example.2)


###################################################
### code chunk number 10: incl-ex2-plot
###################################################
  plot(example.2)


###################################################
### code chunk number 11: scale-1
###################################################
    frac7 <- frac[1:7]/frac[7]


###################################################
### code chunk number 12: scale-2
###################################################
    frac7.ii <- frac.ii[1:7]


###################################################
### code chunk number 13: adj-drift
###################################################
    drift7 <- drift[1:7]/frac[7]^0.5


###################################################
### code chunk number 14: example-3
###################################################
    example.3 <- GrpSeqBnds(frac=frac7, frac.ii=frac7.ii,  
                            EfficacyBoundary=LanDemets(alpha=0.05, spending=ObrienFleming),
                            FutilityBoundary=LanDemets(alpha=0.10, spending=ObrienFleming),
                            drift=drift7)
    SimGSB(example.3)


###################################################
### code chunk number 15: ex3-plot
###################################################
    plot(example.3)


###################################################
### code chunk number 16: incl-ex3-plot
###################################################
    plot(example.3)


###################################################
### code chunk number 17: example-4
###################################################
    example.4 <- update(example.3, FutilityBoundary=LanDemets(alpha=0.05, spending=Pow(1)))
    SimGSB(example.4)


###################################################
### code chunk number 18: ex4-plot
###################################################
    plot(example.4)


###################################################
### code chunk number 19: incl-ex4-plot
###################################################
    plot(example.4)


