% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parseInteractionTerms.R
\name{parseInteractionTerms}
\alias{parseInteractionTerms}
\title{Parse interaction terms}
\usage{
parseInteractionTerms(terms, xlevels, units, format.factor, format.contrast,
  format.scale, format.scale.unit, sep = ": ", ...)
}
\arguments{
\item{terms}{Terms of a formula}

\item{xlevels}{Factor levels corresponding to the variables in
\code{terms}}

\item{units}{named list with unit labels. names should match variable names in formula.}

\item{format.factor}{For categorical variables. A string which specifies the format for factor labels.
The string should contain the keywords \code{"var"} and \code{"level"} which will be
replaced by the name of the variable and the current level, respectively.
Default is \code{"var(level)"}.}

\item{format.contrast}{For categorical variables. A string which specifies the format for constrast statements.
The string should contain the keywords \code{"var"}, \code{"level"} and \code{"ref"} which will be
replaced by the name of the variable, the current level and the reference level, respectively.}

\item{format.scale}{For continuous variables. For categorical variables. A string which specifies the format for factor labels.
The string should contain the keywords \code{"var"} and \code{"level"} which will be
replaced by the name of the variable and the current level, respectively.
Default is \code{"var(level)"}.}

\item{format.scale.unit}{For continuous variables which have a unit. A string which specifies the format for factor labels.
The string should contain the keywords \code{"var"} and \code{"unit"} which will be
replaced by the name of the variable and the unit, respectively.
Default is \code{"var(unit)"}.}

\item{sep}{a character string to separate the terms. Default is \code{": "}.}

\item{...}{Not yet used}
}
\value{
List of contrasts which can be passed to
    \code{lava::estimate}.
}
\description{
Parse interaction terms for regression tables
}
\details{
Prepare a list of contrasts which combines regression coefficients
to describe statistical interactions.
}
\examples{

tt <- terms(formula(SBP~age+sex*BMI))
xlev <- list(sex=c("male","female"),BMI=c("normal","overweight","obese"))
parseInteractionTerms(terms=tt,xlevels=xlev)
parseInteractionTerms(terms=tt,xlevels=xlev,format.factor="var level")
parseInteractionTerms(terms=tt,xlevels=xlev,format.contrast="var(level:ref)")

tt2 <- terms(formula(SBP~age*factor(sex)+BMI))
xlev2 <- list("factor(sex)"=c("male","female"))
parseInteractionTerms(terms=tt2,xlevels=xlev2)
parseInteractionTerms(terms=tt2,xlevels=xlev2,units=list(age="yrs"))


data(Diabetes)
fit <- glm(bp.2s~age*factor(gender)+BMI,data=Diabetes)
parseInteractionTerms(terms=terms(fit$formula),xlevels=fit$xlevels,
                      format.scale="var -- level:ref",units=list("age"='years'))
parseInteractionTerms(terms=terms(fit$formula),xlevels=fit$xlevels,
                      format.scale.unit="var -- level:ref",units=list("age"='years'))
it <- parseInteractionTerms(terms=terms(fit$formula),xlevels=fit$xlevels)
ivars <- unlist(lapply(it,function(x)attr(x,"variables")))
lava::estimate(fit,function(p)lapply(unlist(it),eval,envir=sys.parent(-1)))


}
\seealso{
lava::estimate
}
\author{
Thomas A. Gerds <tag@biostat.ku.dk>
}
