\name{interactiveProjectionBasedClustering}
\alias{interactiveProjectionBasedClustering}
\title{
Interactive Projection-Based Clustering  of [Thrun et al., 2020] based on [Thrun/Ultsch, 2017].
}
\description{
  An interactive clustering tool using the topographic map visualizations of the generalized U-matrix and a variety of different projection methods.
  This function receives a dataset and starts a shiny interface where one is able to choose a projection method and generate a plot.ly visualization of the topograhpic mao [Thrun et al., 2016] of the generalized U-matrix [Ultsch/Thrun, 2017] and the projected points. 
  It includes capabilities for interactive clustering within the interface.
}
\usage{
  interactiveProjectionBasedClustering(Data, Cls=NULL )
}
\arguments{
  \item{Data}{
    The dataset [1:n,1:d] of n cases and d vriables with which the U-matrix and the projection will be calculated.
  }
  \item{Cls}{
     Optional: Prior Classification of the data for the [1:n] cases of k classes.
  }
}
\details{
Cls is a numerical vector of the length n (number of cases) with the integer elements of numbers from 1 to k if k is the number of groups in the data.
Each element of Cls as an unambigous mapping to a case of Data indicating by the rownames of Data. If Data has no rownames a vector from 1:n is generated and then Cls is named by it.
}
\value{
Returns a List of:
  \item{Cls}{A clustering of the dataset for the [1:n] cases of k clusters}
  \item{plot}{The final plot generated by plot.ly when closing the tool}
}
\author{
Felix Pape, Tim Schreier, Luis Winckelmann
}

\references{
[Thrun, 2018]  Thrun, M. C.: Projection Based Clustering through Self-Organization and Swarm Intelligence, doctoral dissertation 2017, Springer, Heidelberg, ISBN: 978-3-658-20539-3, \url{https://doi.org/10.1007/978-3-658-20540-9}, 2018. 

[Ultsch/Thrun, 2017]  Ultsch, A., & Thrun, M. C.: Credible Visualizations for Planar Projections, in Cottrell, M. (Ed.), 12th International Workshop on Self-Organizing Maps and Learning Vector Quantization, Clustering and Data Visualization (WSOM), IEEE Xplore, France, 2017.

[Thrun/Ultsch, 2017]   Thrun, M. C., & Ultsch, A. : Projection based Clustering, Proc. International Federation of Classification Societies (IFCS), pp. 250-251, Japanese Classification Society (JCS), Tokyo, Japan, 2017. 

[Thrun et al., 2020] Thrun, M. C., Pape, F., & Alfred, U.: An Interactive Machine Learning Tool For Clustering in Visual Analytics, technical report beeing submitted, 2020.

}