% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pp_query.R
\name{pp_query}
\alias{pp_query}
\title{Execute a query against the ProPublica API}
\usage{
pp_query(
  query,
  API = c("campaign-finance", "congress"),
  version = "v1",
  page = 1,
  myAPI_Key
)
}
\arguments{
\item{query}{The query to be executed}

\item{API}{Which API are you accessing}

\item{version}{API version. Currently v1.}

\item{page}{Results come in batches of 20. The page parameter specifies which one to retrieve.}

\item{myAPI_Key}{API key from Propublica To use the congress API, you must sign up for an API key.}
}
\value{
a list object with the return values.
}
\description{
This function is primarily meant to be used by other functions in the package, but is made available in case a
"raw query" is required.
}
\examples{
\donttest{
pp_query('115/bills/hr21.json', API = 'congress', version='v1')
pp_query('2018/races/MI/house/11.json', API='campaign-finance',version='v1')
}
}
