% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_recent_nominations_by_category.R
\name{get_recent_nominations_by_category}
\alias{get_recent_nominations_by_category}
\title{Get Recent Nominations by Category}
\usage{
get_recent_nominations_by_category(congress, type, page = 1, myAPI_Key)
}
\arguments{
\item{congress}{107-116}

\item{type}{received, updated, confirmed, withdrawn}

\item{page}{Results come in batches of 20. The page parameter specifies which one to retrieve.}

\item{myAPI_Key}{API key from Propublica To use the congress API, you must sign up for an API key.}
}
\value{
List of returned JSON from endpoint that retrieves  the 20 most recent results for the specified type: received, updated, confirmed or withdrawn.
}
\description{
To get lists of presidential nominations for civilian positions,, use the following function. HTTP Request: GET https://api.propublica.org/congress/v1/{congress}/nominees/{type}.json
}
\examples{
\donttest{
get_recent_nominations_by_category(115, 'confirmed')
}
}
