#' Parameters for Calculating the SDIs Provided by the ScientSDI Function
#'
#' Contains parameters of the gamma and GEV distributions and the
#'  \code{Pr(Rain = 0)}, "probzero.rain".
#'
#' @format A \code{data.frame} with 13 variables and 48 rows.
#'
#' \describe{
#' \item{lon}{longitude in decimal degrees}
#' \item{lat}{latitude in decimal degrees}
#' \item{quart.month}{The quartile of each month}
#' \item{alfa.rain}{Shape parameter of the gamma distribution}
#' \item{beta.rain}{Scale parameter of the gamma distribution}
#' \item{probzero.rain}{Probability of rain=0}
#' \item{loc.harg}{Location parameter of the GEV distribution, PE calculated by
#'   HS method}
#' \item{sc.harg}{Scale parameter of the GEV distribution, PE calculated by HS
#'   method}
#' \item{sh.harg}{Shape parameter of the GEV distribution, PE calculated by HS
#'   method}
#' \item{loc.pm}{Location parameter of the GEV distribution, PE calculated by PM
#'   method}
#' \item{sc.pm}{Scale parameter of the GEV distribution, PE calculated by PM
#'   method}
#' \item{sh.pm}{Shape parameter of the GEV distribution, PE calculated by PM
#'   method}
#' \item{TS}{Time scale at which the SDIs will be calculated}
#' }
#'
#' @source Generated by the \code{ScientSDI()} function using \acronym{NASA}
#'   \acronym{POWER} data.
#'
#' @examples
#' data(DistPar)
"DistPar"
