/*
 * Decompiled with CFR 0.152.
 */
package com.portfolioeffect.quant.client.message.type;

import java.util.HashMap;
import java.util.Map;

public enum FastMessageType {
    LOGON("A"),
    LOGOUT("5"),
    HEARTBEAT("0"),
    TEST_REQUEST("1"),
    REJECT("3"),
    REMOTE_REQUEST("U12"),
    REMOTE_RESPONSE("U13"),
    REMAINING_TRAFFIC_REQUEST("U14"),
    REMAINING_TRAFFIC_RESPONSE("U15"),
    NONPARAM_ESTIMATION_REQUEST("U16"),
    NONPARAM_ESTIMATION_RESPONSE("U17"),
    METRIC_VALIDATION_REQUEST("U18"),
    METRIC_VALIDATION_RESPONSE("U19"),
    PORTFOLIO_ESTIMATION_REQUEST("U20"),
    PORTFOLIO_ESTIMATION_RESPONSE("U21"),
    PORTFOLIO_OPTIMIZATION_REQUEST("U22"),
    PORTFOLIO_OPTIMIZATION_RESPONSE("U23"),
    LOAD_DATA_REQUEST("U24"),
    LOAD_DATA_RESPONSE("U25"),
    TRANSMIT_DATA_REQUEST("U26"),
    TRANSMIT_DATA_RESPONSE("U27"),
    TRANSACTIONAL_PORTFOLIO_ESTIMATION_REQUEST("U28"),
    TEST_UPDATE("U29"),
    TEST_ECHO("U30");

    private String code;
    private static Map<String, FastMessageType> cache;

    private FastMessageType(String code) {
        this.code = code;
    }

    public String getCode() {
        return this.code;
    }

    public static FastMessageType getFastMessageType(String code) {
        return cache.get(code);
    }

    static {
        cache = new HashMap<String, FastMessageType>();
        for (FastMessageType tag : FastMessageType.values()) {
            cache.put(tag.getCode(), tag);
        }
    }
}

