/*
 * Decompiled with CFR 0.152.
 */
package com.portfolioeffect.quant.client.util;

import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class DateTimeUtil {
    public static final long CLIENT_TIME_DELTA;
    private static final DateFormat FULL_DATE_FORMAT;

    static {
        FULL_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        CLIENT_TIME_DELTA = DateTimeUtil.getDeltaMilliSec();
    }

    private static long getDeltaMilliSec() {
        GregorianCalendar dataBaseTime = new GregorianCalendar(TimeZone.getTimeZone("America/New_York"));
        dataBaseTime.setTimeInMillis(new Date().getTime());
        Calendar localTime = Calendar.getInstance();
        long dataBaseMillisec = (dataBaseTime.get(11) * 60 + dataBaseTime.get(12)) * 60 * 1000;
        long localMillisec = (localTime.get(11) * 60 + localTime.get(12)) * 60 * 1000;
        long deltaMillisec = dataBaseMillisec - localMillisec;
        int baseDay = dataBaseTime.get(5);
        int localDay = localTime.get(5);
        if (baseDay < localDay) {
            deltaMillisec -= 86400000L;
        }
        if (baseDay > localDay) {
            deltaMillisec += 86400000L;
        }
        return deltaMillisec;
    }

    public static String[] POSIXTimeToDateStr(long[] timesMills, String formatStr) {
        SimpleDateFormat format = new SimpleDateFormat(formatStr);
        return DateTimeUtil.POSIXTimeToDateStr(timesMills, (DateFormat)format);
    }

    public static String[] POSIXTimeToDateStr(long timesMills, String formatStr) {
        return DateTimeUtil.POSIXTimeToDateStr(new long[]{timesMills}, formatStr);
    }

    public static int[] POSIXTimeToDateInt(long timesMills, String formatStr) {
        return DateTimeUtil.POSIXTimeToDateInt(new long[]{timesMills}, formatStr);
    }

    public static int[] POSIXTimeToDateInt(long[] timesMills, String formatStr) {
        int field = -1;
        if (formatStr.equals("yyyy")) {
            field = 1;
        } else if (formatStr.equals("MM")) {
            field = 2;
        } else if (formatStr.equals("dd")) {
            field = 5;
        } else if (formatStr.equals("uu")) {
            field = 7;
        } else if (formatStr.equals("HH")) {
            field = 11;
        } else if (formatStr.equals("mm")) {
            field = 12;
        } else if (formatStr.equals("ss")) {
            field = 13;
        } else if (formatStr.equals("SSS")) {
            field = 14;
        } else {
            throw new NumberFormatException("Number format not supported.");
        }
        GregorianCalendar dataBaseTime = new GregorianCalendar(TimeZone.getTimeZone("America/New_York"));
        int[] vals = new int[timesMills.length];
        int i = 0;
        while (i < timesMills.length) {
            dataBaseTime.setTimeInMillis(timesMills[i]);
            vals[i] = dataBaseTime.get(field);
            ++i;
        }
        return vals;
    }

    public static String[] POSIXTimeToDateStr(long timesMills, DateFormat dateFormat) {
        return DateTimeUtil.POSIXTimeToDateStr(new long[]{timesMills}, dateFormat);
    }

    public static String[] POSIXTimeToDateStr(long[] timesMills, DateFormat dateFormat) {
        GregorianCalendar dataBaseTime = new GregorianCalendar(TimeZone.getTimeZone("America/New_York"));
        dateFormat.setCalendar(dataBaseTime);
        String[] datesStr = new String[timesMills.length];
        int i = 0;
        while (i < timesMills.length) {
            dataBaseTime.setTimeInMillis(timesMills[i]);
            datesStr[i] = dateFormat.format(dataBaseTime.getTime());
            ++i;
        }
        return datesStr;
    }

    public static String[] POSIXTimeToDateStr(long[] timesMills) {
        return DateTimeUtil.POSIXTimeToDateStr(timesMills, FULL_DATE_FORMAT);
    }

    public static String[] POSIXTimeToDateStr(long timesMills) {
        return DateTimeUtil.POSIXTimeToDateStr(new long[]{timesMills}, FULL_DATE_FORMAT);
    }

    public static long[] toPOSIXTime(String timeString) {
        return DateTimeUtil.toPOSIXTime(new String[]{timeString});
    }

    public static long[] toPOSIXTime(String[] timeString) {
        long[] timeLong = new long[timeString.length];
        int i = 0;
        while (i < timeString.length) {
            timeLong[i] = Timestamp.valueOf(timeString[i]).getTime();
            ++i;
        }
        return timeLong;
    }
}

