% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_sfg.R
\name{build_sfg}
\alias{build_sfg}
\title{Build PopED parameter function from a model function}
\usage{
build_sfg(
  model = "ff.PK.1.comp.oral.sd.CL",
  covariates = c("dose", "tau"),
  par_names = NULL,
  etas = "exp",
  no_etas = c("F", "Favail"),
  env = parent.frame()
)
}
\arguments{
\item{model}{A string of text describing the model function name}

\item{covariates}{A list of covariate names to be filtered out of the model}

\item{par_names}{A list of parameter names in the model file.  If not supplied then 
all undefined variables in the model file are extracted and the covariate names are
filtered out of that list.}

\item{etas}{Can be "exp", "prop", "add" or "none".  Either one value for all parameters or
a list defining the model per parameter.}

\item{no_etas}{Parameters that should not have etas associated with them.}

\item{env}{The environment to create the function in.}
}
\value{
A parameter model function to be used as input to PopED calculations.
}
\description{
Build PopED parameter function from a model function
}
\examples{
build_sfg(model="ff.PK.1.comp.oral.md.CL")

etas <- c(Favail="exp",KA="exp",V="add",CL="exp")
build_sfg(model="ff.PK.1.comp.oral.md.CL",etas = etas)
}
