// Generated by rstantools.  Do not edit by hand.

/*
    PoolTestR is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    PoolTestR is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with PoolTestR.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#include <rstan/rstaninc.hpp>
// Code generated by Stan version 2.21.0
#include <stan/model/model_header.hpp>
namespace model_HierBayesianPoolScreen_namespace {
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;
static int current_statement_begin__;
stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_HierBayesianPoolScreen");
    reader.add_event(55, 53, "end", "model_HierBayesianPoolScreen");
    return reader;
}
#include <stan_meta_header.hpp>
class model_HierBayesianPoolScreen
  : public stan::model::model_base_crtp<model_HierBayesianPoolScreen> {
private:
        int N;
        int L;
        std::vector<int> NumGroups;
        int TotalGroups;
        std::vector<int> Result;
        vector_d PoolSize;
        matrix_d Z;
        double PriorAlpha;
        double PriorBeta;
        double HyperpriorSD;
        std::vector<int> FlippedResult;
        vector_d Zw;
        std::vector<int> Zv;
        std::vector<int> Zu;
public:
    model_HierBayesianPoolScreen(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, 0, pstream__);
    }
    model_HierBayesianPoolScreen(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, random_seed__, pstream__);
    }
    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        typedef double local_scalar_t__;
        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning
        current_statement_begin__ = -1;
        static const char* function__ = "model_HierBayesianPoolScreen_namespace::model_HierBayesianPoolScreen";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        try {
            // initialize data block variables from context__
            current_statement_begin__ = 2;
            context__.validate_dims("data initialization", "N", "int", context__.to_vec());
            N = int(0);
            vals_i__ = context__.vals_i("N");
            pos__ = 0;
            N = vals_i__[pos__++];
            check_greater_or_equal(function__, "N", N, 1);
            current_statement_begin__ = 3;
            context__.validate_dims("data initialization", "L", "int", context__.to_vec());
            L = int(0);
            vals_i__ = context__.vals_i("L");
            pos__ = 0;
            L = vals_i__[pos__++];
            check_greater_or_equal(function__, "L", L, 1);
            current_statement_begin__ = 4;
            validate_non_negative_index("NumGroups", "L", L);
            context__.validate_dims("data initialization", "NumGroups", "int", context__.to_vec(L));
            NumGroups = std::vector<int>(L, int(0));
            vals_i__ = context__.vals_i("NumGroups");
            pos__ = 0;
            size_t NumGroups_k_0_max__ = L;
            for (size_t k_0__ = 0; k_0__ < NumGroups_k_0_max__; ++k_0__) {
                NumGroups[k_0__] = vals_i__[pos__++];
            }
            size_t NumGroups_i_0_max__ = L;
            for (size_t i_0__ = 0; i_0__ < NumGroups_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "NumGroups[i_0__]", NumGroups[i_0__], 1);
            }
            current_statement_begin__ = 5;
            context__.validate_dims("data initialization", "TotalGroups", "int", context__.to_vec());
            TotalGroups = int(0);
            vals_i__ = context__.vals_i("TotalGroups");
            pos__ = 0;
            TotalGroups = vals_i__[pos__++];
            check_greater_or_equal(function__, "TotalGroups", TotalGroups, L);
            current_statement_begin__ = 6;
            validate_non_negative_index("Result", "N", N);
            context__.validate_dims("data initialization", "Result", "int", context__.to_vec(N));
            Result = std::vector<int>(N, int(0));
            vals_i__ = context__.vals_i("Result");
            pos__ = 0;
            size_t Result_k_0_max__ = N;
            for (size_t k_0__ = 0; k_0__ < Result_k_0_max__; ++k_0__) {
                Result[k_0__] = vals_i__[pos__++];
            }
            size_t Result_i_0_max__ = N;
            for (size_t i_0__ = 0; i_0__ < Result_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "Result[i_0__]", Result[i_0__], 0);
                check_less_or_equal(function__, "Result[i_0__]", Result[i_0__], 1);
            }
            current_statement_begin__ = 7;
            validate_non_negative_index("PoolSize", "N", N);
            context__.validate_dims("data initialization", "PoolSize", "vector_d", context__.to_vec(N));
            PoolSize = Eigen::Matrix<double, Eigen::Dynamic, 1>(N);
            vals_r__ = context__.vals_r("PoolSize");
            pos__ = 0;
            size_t PoolSize_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < PoolSize_j_1_max__; ++j_1__) {
                PoolSize(j_1__) = vals_r__[pos__++];
            }
            check_greater_or_equal(function__, "PoolSize", PoolSize, 0);
            current_statement_begin__ = 9;
            validate_non_negative_index("Z", "N", N);
            validate_non_negative_index("Z", "TotalGroups", TotalGroups);
            context__.validate_dims("data initialization", "Z", "matrix_d", context__.to_vec(N,TotalGroups));
            Z = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(N, TotalGroups);
            vals_r__ = context__.vals_r("Z");
            pos__ = 0;
            size_t Z_j_2_max__ = TotalGroups;
            size_t Z_j_1_max__ = N;
            for (size_t j_2__ = 0; j_2__ < Z_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < Z_j_1_max__; ++j_1__) {
                    Z(j_1__, j_2__) = vals_r__[pos__++];
                }
            }
            check_greater_or_equal(function__, "Z", Z, 0);
            check_less_or_equal(function__, "Z", Z, 1);
            current_statement_begin__ = 10;
            context__.validate_dims("data initialization", "PriorAlpha", "double", context__.to_vec());
            PriorAlpha = double(0);
            vals_r__ = context__.vals_r("PriorAlpha");
            pos__ = 0;
            PriorAlpha = vals_r__[pos__++];
            check_greater_or_equal(function__, "PriorAlpha", PriorAlpha, 0);
            current_statement_begin__ = 11;
            context__.validate_dims("data initialization", "PriorBeta", "double", context__.to_vec());
            PriorBeta = double(0);
            vals_r__ = context__.vals_r("PriorBeta");
            pos__ = 0;
            PriorBeta = vals_r__[pos__++];
            check_greater_or_equal(function__, "PriorBeta", PriorBeta, 0);
            current_statement_begin__ = 12;
            context__.validate_dims("data initialization", "HyperpriorSD", "double", context__.to_vec());
            HyperpriorSD = double(0);
            vals_r__ = context__.vals_r("HyperpriorSD");
            pos__ = 0;
            HyperpriorSD = vals_r__[pos__++];
            check_greater_or_equal(function__, "HyperpriorSD", HyperpriorSD, 0);
            // initialize transformed data variables
            current_statement_begin__ = 15;
            validate_non_negative_index("FlippedResult", "N", N);
            FlippedResult = std::vector<int>(N, int(0));
            stan::math::fill(FlippedResult, std::numeric_limits<int>::min());
            current_statement_begin__ = 17;
            validate_non_negative_index("Zw", "(L * N)", (L * N));
            Zw = Eigen::Matrix<double, Eigen::Dynamic, 1>((L * N));
            stan::math::fill(Zw, DUMMY_VAR__);
            current_statement_begin__ = 18;
            validate_non_negative_index("Zv", "(L * N)", (L * N));
            Zv = std::vector<int>((L * N), int(0));
            stan::math::fill(Zv, std::numeric_limits<int>::min());
            current_statement_begin__ = 19;
            validate_non_negative_index("Zu", "(N + 1)", (N + 1));
            Zu = std::vector<int>((N + 1), int(0));
            stan::math::fill(Zu, std::numeric_limits<int>::min());
            // execute transformed data statements
            current_statement_begin__ = 20;
            stan::math::assign(Zw, csr_extract_w(Z));
            current_statement_begin__ = 21;
            stan::math::assign(Zv, csr_extract_v(Z));
            current_statement_begin__ = 22;
            stan::math::assign(Zu, csr_extract_u(Z));
            current_statement_begin__ = 24;
            for (int n = 1; n <= N; ++n) {
                current_statement_begin__ = 25;
                stan::model::assign(FlippedResult, 
                            stan::model::cons_list(stan::model::index_uni(n), stan::model::nil_index_list()), 
                            (1 - get_base1(Result, n, "Result", 1)), 
                            "assigning variable FlippedResult");
            }
            // validate transformed data
            current_statement_begin__ = 15;
            size_t FlippedResult_i_0_max__ = N;
            for (size_t i_0__ = 0; i_0__ < FlippedResult_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "FlippedResult[i_0__]", FlippedResult[i_0__], 0);
                check_less_or_equal(function__, "FlippedResult[i_0__]", FlippedResult[i_0__], 1);
            }
            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            current_statement_begin__ = 29;
            num_params_r__ += 1;
            current_statement_begin__ = 30;
            validate_non_negative_index("u", "TotalGroups", TotalGroups);
            num_params_r__ += TotalGroups;
            current_statement_begin__ = 31;
            validate_non_negative_index("group_sd", "L", L);
            num_params_r__ += L;
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    ~model_HierBayesianPoolScreen() { }
    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        typedef double local_scalar_t__;
        stan::io::writer<double> writer__(params_r__, params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;
        current_statement_begin__ = 29;
        if (!(context__.contains_r("p")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable p missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("p");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "p", "double", context__.to_vec());
        double p(0);
        p = vals_r__[pos__++];
        try {
            writer__.scalar_lub_unconstrain(0, 1, p);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable p: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 30;
        if (!(context__.contains_r("u")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable u missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("u");
        pos__ = 0U;
        validate_non_negative_index("u", "TotalGroups", TotalGroups);
        context__.validate_dims("parameter initialization", "u", "vector_d", context__.to_vec(TotalGroups));
        Eigen::Matrix<double, Eigen::Dynamic, 1> u(TotalGroups);
        size_t u_j_1_max__ = TotalGroups;
        for (size_t j_1__ = 0; j_1__ < u_j_1_max__; ++j_1__) {
            u(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_unconstrain(u);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable u: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 31;
        if (!(context__.contains_r("group_sd")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable group_sd missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("group_sd");
        pos__ = 0U;
        validate_non_negative_index("group_sd", "L", L);
        context__.validate_dims("parameter initialization", "group_sd", "vector_d", context__.to_vec(L));
        Eigen::Matrix<double, Eigen::Dynamic, 1> group_sd(L);
        size_t group_sd_j_1_max__ = L;
        for (size_t j_1__ = 0; j_1__ < group_sd_j_1_max__; ++j_1__) {
            group_sd(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_lb_unconstrain(0, group_sd);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable group_sd: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }
    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }
    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(std::vector<T__>& params_r__,
                 std::vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {
        typedef T__ local_scalar_t__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // dummy to suppress unused var warning
        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;
        try {
            stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
            // model parameters
            current_statement_begin__ = 29;
            local_scalar_t__ p;
            (void) p;  // dummy to suppress unused var warning
            if (jacobian__)
                p = in__.scalar_lub_constrain(0, 1, lp__);
            else
                p = in__.scalar_lub_constrain(0, 1);
            current_statement_begin__ = 30;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> u;
            (void) u;  // dummy to suppress unused var warning
            if (jacobian__)
                u = in__.vector_constrain(TotalGroups, lp__);
            else
                u = in__.vector_constrain(TotalGroups);
            current_statement_begin__ = 31;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> group_sd;
            (void) group_sd;  // dummy to suppress unused var warning
            if (jacobian__)
                group_sd = in__.vector_lb_constrain(0, L, lp__);
            else
                group_sd = in__.vector_lb_constrain(0, L);
            // model body
            {
            current_statement_begin__ = 34;
            int k(0);
            (void) k;  // dummy to suppress unused var warning
            stan::math::fill(k, std::numeric_limits<int>::min());
            current_statement_begin__ = 35;
            validate_non_negative_index("ps", "N", N);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> ps(N);
            stan::math::initialize(ps, DUMMY_VAR__);
            stan::math::fill(ps, DUMMY_VAR__);
            current_statement_begin__ = 36;
            validate_non_negative_index("au", "TotalGroups", TotalGroups);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> au(TotalGroups);
            stan::math::initialize(au, DUMMY_VAR__);
            stan::math::fill(au, DUMMY_VAR__);
            current_statement_begin__ = 37;
            stan::math::assign(k, 1);
            current_statement_begin__ = 38;
            for (int l = 1; l <= L; ++l) {
                current_statement_begin__ = 39;
                stan::model::assign(au, 
                            stan::model::cons_list(stan::model::index_min_max(k, ((k + get_base1(NumGroups, l, "NumGroups", 1)) - 1)), stan::model::nil_index_list()), 
                            multiply(stan::model::rvalue(u, stan::model::cons_list(stan::model::index_min_max(k, ((k + get_base1(NumGroups, l, "NumGroups", 1)) - 1)), stan::model::nil_index_list()), "u"), get_base1(group_sd, l, "group_sd", 1)), 
                            "assigning variable au");
                current_statement_begin__ = 40;
                stan::math::assign(k, (k + get_base1(NumGroups, l, "NumGroups", 1)));
            }
            current_statement_begin__ = 47;
            stan::math::assign(ps, stan::math::exp(elt_multiply(log1m_inv_logit(add(logit(p), csr_matrix_times_vector(N, TotalGroups, Zw, Zv, Zu, au))), PoolSize)));
            current_statement_begin__ = 49;
            lp_accum__.add(normal_log<propto__>(u, 0, 1));
            current_statement_begin__ = 50;
            lp_accum__.add(cauchy_log<propto__>(group_sd, 0, HyperpriorSD));
            current_statement_begin__ = 51;
            lp_accum__.add(beta_log<propto__>(p, PriorAlpha, PriorBeta));
            current_statement_begin__ = 52;
            lp_accum__.add(bernoulli_log<propto__>(FlippedResult, ps));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
        lp_accum__.add(lp__);
        return lp_accum__.sum();
    } // log_prob()
    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }
    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("p");
        names__.push_back("u");
        names__.push_back("group_sd");
    }
    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(TotalGroups);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(L);
        dimss__.push_back(dims__);
    }
    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        typedef double local_scalar_t__;
        vars__.resize(0);
        stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
        static const char* function__ = "model_HierBayesianPoolScreen_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        double p = in__.scalar_lub_constrain(0, 1);
        vars__.push_back(p);
        Eigen::Matrix<double, Eigen::Dynamic, 1> u = in__.vector_constrain(TotalGroups);
        size_t u_j_1_max__ = TotalGroups;
        for (size_t j_1__ = 0; j_1__ < u_j_1_max__; ++j_1__) {
            vars__.push_back(u(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> group_sd = in__.vector_lb_constrain(0, L);
        size_t group_sd_j_1_max__ = L;
        for (size_t j_1__ = 0; j_1__ < group_sd_j_1_max__; ++j_1__) {
            vars__.push_back(group_sd(j_1__));
        }
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        if (!include_tparams__ && !include_gqs__) return;
        try {
            if (!include_gqs__ && !include_tparams__) return;
            if (!include_gqs__) return;
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng, params_r_vec, params_i_vec, vars_vec, include_tparams, include_gqs, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }
    std::string model_name() const {
        return "model_HierBayesianPoolScreen";
    }
    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        param_name_stream__.str(std::string());
        param_name_stream__ << "p";
        param_names__.push_back(param_name_stream__.str());
        size_t u_j_1_max__ = TotalGroups;
        for (size_t j_1__ = 0; j_1__ < u_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "u" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t group_sd_j_1_max__ = L;
        for (size_t j_1__ = 0; j_1__ < group_sd_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "group_sd" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
        }
        if (!include_gqs__) return;
    }
    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        param_name_stream__.str(std::string());
        param_name_stream__ << "p";
        param_names__.push_back(param_name_stream__.str());
        size_t u_j_1_max__ = TotalGroups;
        for (size_t j_1__ = 0; j_1__ < u_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "u" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t group_sd_j_1_max__ = L;
        for (size_t j_1__ = 0; j_1__ < group_sd_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "group_sd" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
        }
        if (!include_gqs__) return;
    }
}; // model
}  // namespace
typedef model_HierBayesianPoolScreen_namespace::model_HierBayesianPoolScreen stan_model;
#ifndef USING_R
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
#endif
#endif
