% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PolynomF.R
\name{poly.orth}
\alias{poly.orth}
\title{Orthogonal polynomials}
\usage{
poly.orth(x, degree = length(unique(x)) - 1, norm = TRUE)
}
\arguments{
\item{x}{A numeric vector}

\item{degree}{The desired maximum degree}

\item{norm}{Logical: should polynomials be normalised to length one?}
}
\value{
A list of orthogonal polynomials
}
\description{
Generate a list of polynomials up to a specified degree,
orthogonal with respect to the natural inner product
}
\examples{
x <- c(0:3, 5)
P <- poly.orth(x)
plot(P)
Pf <- as.function(P)
zapsmall(crossprod(Pf(x)))
}
