% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PoloniexPublic.R
\name{SetPoloniexPublicURL}
\alias{SetPoloniexPublicURL}
\title{Setter for REST service URL for the Poloniex public API}
\usage{
SetPoloniexPublicURL(theObject, base.url)
}
\arguments{
\item{theObject}{The public client API object on which the function should be called}

\item{base.url}{length-one character vector. Represents the REST service URL.}
}
\value{
theObject - a copy of the object with the modified base.url slot
}
\description{
Setter for REST service URL for the Poloniex public API
}
\examples{
poloniex.public <- PoloniexPublicAPI(base.url = "https://not_working/public?")
poloniex.public <- SetPoloniexPublicURL(poloniex.public,
                                        base.url = "https://poloniex.com/public?")
GetPoloniexPublicURL(poloniex.public)
}
