% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlasmodeCont.R
\name{PlasmodeCont}
\alias{PlasmodeCont}
\title{Performs the plasmode simulation}
\usage{
PlasmodeCont(formulaOut = NULL, objectOut = NULL, formulaExp = NULL,
  objectExp = NULL, data, idVar, effectOR = 1, MMOut = 1, MMExp = 1,
  nsim, size, eventRate = NULL, exposedPrev = NULL)
}
\arguments{
\item{formulaOut}{An outcome model formula containing the continuous outcome on the left-hand side and binary exposure along with potential confounders on the right-hand side.The functional form of the outcome model should be, Outcome ~ Exposure + Confounders. (Exposure main effect must be first independent variable).}

\item{objectOut}{A fitted model for the outcome model. The functional form of the fitted model for the outcome variable should be of form, Outcome ~ Exposure + Confounders.}

\item{formulaExp}{An exposure model formula containing the binary exposure on the left-hand side and potential confounders on the right-hand side. The functional form of the exposure model is, Exposure ~ Confounders.}

\item{objectExp}{A fitted model object for the exposure model.}

\item{data}{The dataset on which simulations are based. The data is required only when formulaOut or formulaExp or both are supplied to the argument.}

\item{idVar}{Name of the ID variable}

\item{effectOR}{The desired treatment effect odd ratio. By default effectOR = 1.}

\item{MMOut}{A multiplier of confounder effects on outcome applied to the estimated log ORs in the outcome model. By default MMOut = 1 but one can specify a vector of length equivalent to the number of variables on the right-hand side of the outcome model.}

\item{MMExp}{A multiplier of confounder effects on exposure applied to the estimated log ORs in the exposure model. By default MMExp = 1 but one can specify a vector of length equivalent to the number of variables on the right-hand side of the exposure model.}

\item{nsim}{Number of desired simulated datasets.}

\item{size}{Desired size of simulated datasets (i.e., # of individuals).}

\item{eventRate}{Desired average event rate. Default is the event rate in the observed data.}

\item{exposedPrev}{Desired average exposure rate. Default is the esposure prevalence in the observed data.}
}
\value{
PlasmodeCont returns true beta coefficients used to generate the outcome and the exposure. It also returns the relative risk and risk difference estimated by the plasmode simulated data along with the data frame with the simulated data, including sampled IDs for each of nsim datasets along with simulated outcomes, exposure, or both.
\item{TrueOutBeta}{True beta coefficients used to generate the outcome.}
\item{TrueExpBeta}{True beta coefficients used to generate the exposure.}
\item{RR}{True relative risk estimated using the plasmode simulated data.}
\item{RD}{True risk difference estimated using the plasmode simulated data.}
\item{Sim_Data}{Plasmode simulated data, including sampled IDs for each of nsim datasets along with simulated outcomes, exposure, or both.}
}
\description{
Creates 'plasmode' simulated datasets based on a given dataset when the outcome variable is continuous and exposure variable is binary. Plasmode simulation samples subjects with replacement from the observed data, uses subjects’ covariate data as is, and simulates exposure, outcome, or both.
}
\details{
At least one of formulaOut, formulaExp, objectOut, and objectExp must be specified, and which of these are specified will determine what gets simulated and how. If objectOut or objectExp are specified, these objects are used as the base model for outcome and exposure simulation. If formulaOut or formulaExp are specified, then data should be given and base models are fit in the data using glm2 with the given formulas. If formulaOut or objectOut is specified, outcome will be simulated based on subjects’ observed exposure. If formulaExp or objectExp is specified, exposure will be simulated. And if models are specified for both outcome and exposure, both variables will be simulated with simulated outcome dependent on the simulated exposure.
}
\examples{
{
## Example for using the PlasmodeCont
library(twang)
library(gbm)
library(lattice)
library(parallel)
library(survey)
library(grid)
library(Matrix)
library(xtable)
library(latticeExtra)
library(RColorBrewer)
library(arm)
set.seed(1)
data("lalonde")
## Creating the ID variable
lalonde$id <- 1:nrow(lalonde)

str(lalonde)
## Example for PlasmodeCont when the outcome and exposure models formulas are provided.
form1<- re78 ~ treat + age + educ + black + hisp+ nodegr  + married + re74 + re75
form2<- treat ~ age + educ + black + hisp + nodegr + married + re74 + re75
Cont_Form1<-PlasmodeCont(formulaOut=form1, objectOut = NULL,formulaExp=form2,objectExp = NULL,
                        data=lalonde,idVar="id",effectOR =0, MMOut=c(0,1,2,1,1,1,2,2,1),
                        MMExp=c(1,2,1,1,1,2,2,1),nsim=2, size=nrow(lalonde),
                        eventRate=NULL, exposedPrev=NULL)
Cont_Form2<-PlasmodeCont(formulaOut=form1, objectOut = NULL,formulaExp=NULL,objectExp = NULL,
                        data=lalonde,idVar="id",effectOR =0, MMOut=c(0,1,2,1,1,1,2,2,1),MMExp=1,
                        nsim=2, size=nrow(lalonde), eventRate=NULL, exposedPrev=NULL)
Cont_Form3<-PlasmodeCont(formulaOut=NULL, objectOut = NULL,formulaExp=form2,objectExp = NULL,
                        data=lalonde,idVar="id",effectOR =0, MMOut=1,MMExp=c(1,2,1,1,1,2,2,1),
                        nsim=2, size=nrow(lalonde), eventRate=NULL, exposedPrev=NULL)
## Example for PlasmodeCont when the fitted model objects are provided.
###################################################################################################
## One can provide the fitted model for the outcome model and the exposure model estimated by
## glm, gam, and bayesglm. The functional form of the fitted model for the outcome variable should
## of the form Outcome ~ Exposure + Confounders. The functional form of the exposure model is,
## Exposure ~ Confounders.
####################################################################################################
Coeff1c<- bayesglm(form1, family = "gaussian", data=lalonde,control=glm.control(trace=TRUE))
Coeff2c<- bayesglm(form2, family = "binomial", data=lalonde,control=glm.control(trace=TRUE))

sizesim<-nrow(model.matrix(Coeff1c))
sizesim1<-nrow(model.matrix(Coeff2c))

Cont_Obj1<-PlasmodeCont(formulaOut=NULL, objectOut = Coeff1c,formulaExp=NULL,objectExp = Coeff2c,
                       idVar=lalonde$id,effectOR =0, MMOut=c(0,1,2,1,1,1,2,2,1),
                       MMExp=c(1,2,1,1,1,2,2,1),
                       nsim=2, size=nrow(lalonde), eventRate=NULL, exposedPrev=NULL)

Cont_Obj2<-PlasmodeCont(formulaOut=NULL, objectOut = Coeff1c,formulaExp=NULL,objectExp = NULL,
                       idVar=lalonde$id,effectOR =1, MMOut=c(0,1,2,1,1,1,2,2,1),MMExp=1,
                       nsim=2, size=nrow(lalonde), eventRate=NULL, exposedPrev=NULL)

Cont_Obj3<-PlasmodeCont(formulaOut=NULL, objectOut = NULL,formulaExp=NULL,objectExp = Coeff2c,
                       idVar=lalonde$id,effectOR =1, MMOut=c(0,1,2,1,1,1,2,2,1),MMExp=1,
                       nsim=2, size=nrow(lalonde), eventRate=NULL, exposedPrev=NULL)
}
}
\author{
Jessica M. Franklin, Younathan Abdia, and Shirley Wang
}
