% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/GWC.R
\name{gwc}
\alias{gwc}
\title{Calculate the gwc score between two vectors, using either a weighted spearman or pearson correlation}
\usage{
gwc(x1, p1, x2, p2, method.cor = c("pearson", "spearman"), nperm = 10000,
  ...)
}
\arguments{
\item{x1}{\code{numeric} vector of effect sizes (e.g., fold change or t statitsics) for the first experiment}

\item{p1}{\code{numeric} vector of p-values for each corresponding effect size for the first experiment}

\item{x2}{\code{numeric} effect size (e.g., fold change or t statitsics) for the second experiment}

\item{p2}{\code{numeric} vector of p-values for each corresponding effect size for the second experiment}

\item{method.cor}{\code{character} string identifying if a \code{pearson} or
  \code{spearman} correlation should be used}

\item{nperm}{\code{numeric} how many permutations should be done to determine}

\item{...}{Other passed down to internal functions}
}
\value{
\code{numeric} a vector of two values, the correlation and associated p-value.
}
\description{
Calculate the gwc score between two vectors, using either a weighted spearman or pearson correlation
}

