% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LP_test_equal_recap.R
\name{LP_test_equal_recap}
\alias{LP_test_equal_recap}
\title{Test for equal recapture probability in LP experiment}
\usage{
LP_test_equal_recap(data, strat_var, do.fisher.test = FALSE)
}
\arguments{
\item{data}{Data frame containing the variables:
\itemize{
\item \strong{cap_hist} Capture history (see details below)
\item \strong{freq} Number of times this capture history was observed
}
plus any other covariates (e.g. discrete strata and/or continuous covariates) to be used
in the model fitting.}

\item{strat_var}{Variable in the dataframe that serves as a stratification variable for contingency table tests
of equal marked fraction or equal recapture probability}

\item{do.fisher.test}{Should a fisher exact test be done?}
}
\value{
List containing the contingency table and the chi-square test and fisher-exact test
}
\description{
This function takes the capture histories and stratification variable and computes the test
for equal recapture probabilities.
}
\examples{

data(data_NorthernPike)
LP_test_equal_recap(data_NorthernPike, "Sex")

}
