% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addCohortIntersect.R
\name{addCohortIntersect}
\alias{addCohortIntersect}
\title{Compute the intersect with a target cohort, you can compute the number of
occurrences, a flag of presence, a certain date and/or the time difference}
\usage{
addCohortIntersect(
  x,
  cdm = lifecycle::deprecated(),
  targetCohortTable,
  targetCohortId = NULL,
  indexDate = "cohort_start_date",
  censorDate = NULL,
  targetStartDate = "cohort_start_date",
  targetEndDate = "cohort_end_date",
  window = list(c(0, Inf)),
  order = "first",
  flag = TRUE,
  count = TRUE,
  date = TRUE,
  days = TRUE,
  nameStyle = "{value}_{cohort_name}_{window_name}"
)
}
\arguments{
\item{x}{Table with individuals in the cdm.}

\item{cdm}{Object that contains a cdm reference. Use CDMConnector to obtain a
cdm reference.}

\item{targetCohortTable}{name of the cohort that we want to check for overlap.}

\item{targetCohortId}{vector of cohort definition ids to include.}

\item{indexDate}{Variable in x that contains the date to compute the
intersection.}

\item{censorDate}{whether to censor overlap events at a specific date
or a column date of x.}

\item{targetStartDate}{date of reference in cohort table, either for start
(in overlap) or on its own (for incidence).}

\item{targetEndDate}{date of reference in cohort table, either for end
(overlap) or NULL (if incidence).}

\item{window}{window to consider events of.}

\item{order}{which record is considered in case of multiple records.}

\item{flag}{TRUE or FALSE. If TRUE, flag will calculated for this
intersection.}

\item{count}{TRUE or FALSE. If TRUE, the number of counts will be calculated
for this intersection.}

\item{date}{TRUE or FALSE. If TRUE, date will be calculated for this
intersection.}

\item{days}{TRUE or FALSE. If TRUE, time difference in days will be
calculated for this intersection.}

\item{nameStyle}{naming of the added column or columns, should include
required parameters.}
}
\value{
table with added columns with overlap information.
}
\description{
Compute the intersect with a target cohort, you can compute the number of
occurrences, a flag of presence, a certain date and/or the time difference
}
\examples{
\donttest{
cdm <- mockPatientProfiles()

cdm$cohort1 \%>\%
  addCohortIntersect(
    targetCohortTable = "cohort2"
  )
CDMConnector::cdmDisconnect(cdm = cdm)
}

}
