% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addDemographics.R
\name{addPriorObservation}
\alias{addPriorObservation}
\title{Compute the number of days of prior observation in the current observation period
at a certain date}
\usage{
addPriorObservation(
  x,
  cdm = lifecycle::deprecated(),
  indexDate = "cohort_start_date",
  priorObservationName = "prior_observation",
  priorObservationType = "days"
)
}
\arguments{
\item{x}{Table with individuals in the cdm.}

\item{cdm}{A cdm_reference object.}

\item{indexDate}{Variable in x that contains the date to compute the prior
observation.}

\item{priorObservationName}{name of the new column to be added.}

\item{priorObservationType}{Whether to return a "date" or the number of
"days".}
}
\value{
cohort table with added column containing prior observation of the
individuals.
}
\description{
Compute the number of days of prior observation in the current observation period
at a certain date
}
\examples{
\donttest{
cdm <- mockPatientProfiles()

cdm$cohort1 \%>\%
  addPriorObservation()
CDMConnector::cdmDisconnect(cdm = cdm)
}
}
