% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Fit.R
\name{fitPlp}
\alias{fitPlp}
\title{fitPlp}
\usage{
fitPlp(trainData, modelSettings, search = "grid", analysisId, analysisPath)
}
\arguments{
\item{trainData}{An object of type \code{trainData} created using \code{splitData}
data extracted from the CDM.}

\item{modelSettings}{An object of class \code{modelSettings} created using
one of the \code{createModelSettings} functions}

\item{search}{The search strategy for the hyper-parameter selection (currently not used)}

\item{analysisId}{The id of the analysis}

\item{analysisPath}{The path of the analysis}
}
\value{
An object of class \code{plpModel} containing:

\item{model}{The trained prediction model}
\item{preprocessing}{The preprocessing required when applying the model}
\item{prediction}{The cohort data.frame with the predicted risk column added}
\item{modelDesign}{A list specifiying the modelDesign settings used to fit the model}
\item{trainDetails}{The model meta data}
\item{covariateImportance}{The covariate importance for the model}
}
\description{
Train various models using a default parameter grid search or user specified
parameters
}
\details{
The user can define the machine learning model to train
}
\examples{
\donttest{ \dontshow{ # takes too long }
# simulate data
data("simulationProfile")
plpData <- simulatePlpData(simulationProfile, n=1000)
# create study population, split into train/test and preprocess with default settings
population <- createStudyPopulation(plpData, outcomeId = 3)
data <- splitData(plpData, population, createDefaultSplitSetting())
data$Train$covariateData <- preprocessData(data$Train$covariateData)
saveLoc <- file.path(tempdir(), "fitPlp")
# fit a lasso logistic regression model using the training data
plpModel <- fitPlp(data$Train, modelSettings=setLassoLogisticRegression(seed=42),
                   analysisId=1, analysisPath=saveLoc)
# show evaluationSummary for model
evaluatePlp(plpModel$prediction)$evaluationSummary
# clean up
unlink(saveLoc, recursive = TRUE)
}
}
