% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{Local_Pareto_Alpha}
\alias{Local_Pareto_Alpha}
\title{Local Pareto Alpha}
\usage{
Local_Pareto_Alpha(x, distribution, ...)
}
\arguments{
\item{x}{Numeric. Vector of thresholds at which the local Pareto alpha is calculated.}

\item{distribution}{Character. \itemize{
\item \code{'lnorm'} for lognormal distribution (arguments: \code{meanlog}, \code{sdlog})
\item \code{'norm'} for normal distribution (arguments: \code{mean}, \code{sd})
\item \code{'gamma'} for gamma distribution (arguments: \code{shape}, \code{rate}, \code{scale})
}}

\item{...}{Arguments for the selected distribution}
}
\value{
Local Pareto alpha of the selected distribution at \code{x}
}
\description{
Calculates the local Pareto alpha of the normal, lognormal and gamma distribution
}
\examples{
x <- 1:10
Local_Pareto_Alpha(x, "norm", mean = 1, sd = 5)
x <- 1:10 * 1000000
Local_Pareto_Alpha(x, "lnorm", meanlog = 1, sdlog = 5)

}
\references{
Riegel, U. (2008) Generalizations of common ILF models. Blaetter der DGVFM 29: 45--71
}
