% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Cluster.R
\name{clusterApply}
\alias{clusterApply}
\title{Apply a function to a list using the cluster}
\usage{
clusterApply(cluster, x, fun, ..., stopOnError = FALSE, progressBar = TRUE)
}
\arguments{
\item{cluster}{The cluster of threads to run the function.}

\item{x}{The list on which the function will be applied.}

\item{fun}{The function to apply. Note that the context in which the function is specifies
matters (see details).}

\item{...}{Additional parameters for the function.}

\item{stopOnError}{Stop when one of the threads reports an error? If FALSE, all errors will be
reported at the end.}

\item{progressBar}{Show a progress bar?}
}
\value{
A list with the result of the function on each item in x.
}
\description{
Apply a function to a list using the cluster
}
\details{
The function will be executed on each element of x in the threads of the cluster. If there are more
elements than threads, the elements will be queued. The progress bar will show the number of
elements that have been completed. It can sometimes be important to realize that the context in
which a function is created is also transmitted to the worker node. If a function is defined inside
another function, and that outer function is called with a large argument, that argument will be
transmitted to the worker node each time the function is executed. It can therefore make sense to
define the function to be called at the package level rather than inside a function, to save
overhead.
}
\examples{
fun <- function(x) {
  return (x^2)
}

cluster <- makeCluster(numberOfThreads = 3)
clusterApply(cluster, 1:10, fun)
stopCluster(cluster)
}
