% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.PandemicData.R
\name{plot.pandemicData}
\alias{plot.pandemicData}
\title{Plot pandemic data}
\usage{
\method{plot}{pandemicData}(x, y, cases = "new", color = TRUE, ...)
}
\arguments{
\item{x}{Output of function \code{\link{load_covid}}.}

\item{y}{This parameter does nothing}

\item{cases}{A string which indicates whether new cases, cumulative cases or both plots should be generated.
The argument must be a string being either 'new', 'cumulative' or 'both'.}

\item{color}{A string which indicates whether the plot should be colorful or in gray scales.
The argument must be a string being either TRUE or FALSE.}

\item{...}{Currently unused.}
}
\value{
A list containing two objects, new and cumulative "new" shows the plot for the new cases/deaths
and "cumulative" shows the plot for the cumulative cases/deaths. If any of them did not get plotted due to lack of prediction or due to the \code{cases}
argument, its value will return NULL.

By default, only the plot with new cases is generated.
This is changed with the \code{cases} argument.
\item{\code{new}}{
  The plotted new cases/deaths. The plots are for daily new confirmed cases and daily new deaths.
  }
  \item{\code{cumulative}}{
  The plotted cumulative cases/deaths. The plots are for daily cumulative cases or daily cumulative deaths.
  }
}
\description{
S3 method that plots the predicted data into an interactive graphic.
}
\examples{
\dontrun{
dataMG = load_covid(country_name="Brazil",state_name = "MG",last_date="2020-10-01")
plot(dataMG)
dataJapan = load_covid(country_name="Japan",last_date="2020-10-01")
plot(dataJapan)
}
}
\references{
CovidLP Team, 2020. CovidLP: Short and Long-term Prediction for COVID-19. Departamento de Estatistica. UFMG,
Brazil. URL: \url{http://est.ufmg.br/covidlp/home/en/}
}
\seealso{
\code{\link{load_covid}}.
}
