% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PaRe-package.R
\docType{data}
\name{whiteList}
\alias{whiteList}
\title{whiteList}
\format{
An object of class \code{tbl_df} (inherits from \code{tbl}, \code{data.frame}) with 3 rows and 4 columns.
}
\usage{
whiteList
}
\description{
data.frame containing links to csv-files which should be used to fetch
white-listed dependencies.
}
\details{
By default three csv's are listed:
\enumerate{
\item darwin
\item hades
\item tidyverse
}

The data.frame is locally fetched under:
\code{system.file(package = "PaRe", "whiteList.csv")}

Manual insertions into this data.frame can be made, or the data.frame can
be overwritten entirely.

The data.frame itself has the following structure:\tabular{lll}{
   column \tab data type \tab description \cr
   source \tab \link[base]{character} \tab name of the source \cr
   link \tab \link[base]{character} \tab link or path to the csv-file \cr
   package \tab \link[base]{character} \tab columnname of the package name column in the csv-file being linked to \cr
   version \tab \link[base]{character} \tab columnname of the version column in the csv-file being linked to \cr
}


The csv-files that are being pointed to should have the following structure:
}
\examples{
if (interactive()) {
  # Dropping tidyverse
  whiteList <- whiteList \%>\%
    dplyr::filter(source != "tidyverse")

  # getDefaultPermittedPackages will now only use darwin and hades
  getDefaultPermittedPackages()
}
}
\keyword{datasets}
