% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getDefinedFunctions.R
\name{getDefinedFunctions}
\alias{getDefinedFunctions}
\title{getDefinedFunctions}
\usage{
getDefinedFunctions(repo)
}
\arguments{
\item{repo}{(\link[PaRe]{Repository})\cr
Repository object.}
}
\value{
(\link[base]{data.frame})\tabular{ll}{
   column \tab data type \cr
   name \tab \link[base]{character} \cr
   lineStart \tab \link[base]{integer} \cr
   lineEnd \tab \link[base]{numeric} \cr
   nArgs \tab \link[base]{integer} \cr
   cycloComp \tab \link[base]{integer} \cr
   fileName \tab \link[base]{character} \cr
}
}
\description{
Gets all the defined functions from a \link[PaRe]{Repository} object.
}
\examples{
fetchedRepo <- tryCatch(
  {
    # Set dir to clone repository to.
    tempDir <- tempdir()
    pathToRepo <- file.path(tempDir, "glue")

    # Clone repo
    git2r::clone(
      url = "https://github.com/tidyverse/glue.git",
      local_path = pathToRepo
    )

    # Create instance of Repository object.
    repo <- PaRe::Repository$new(path = pathToRepo)

    # Set fetchedRepo to TRUE if all goes well.
    TRUE
  },
  error = function(e) {
    # Set fetchedRepo to FALSE if an error is encountered.
    FALSE
  },
  warning = function(w) {
    # Set fetchedRepo to FALSE if a warning is encountered.
    FALSE
  }
)

if (fetchedRepo) {
  repo <- PaRe::Repository$new(pathToRepo)

  getDefinedFunctions(repo)
}
}
