% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrccDump_createMonitorObject.R
\name{wrccDump_createMonitorObject}
\alias{wrccDump_createMonitorObject}
\title{Ingest WRCC Dump File and Create ws_monitor Object}
\usage{
wrccDump_createMonitorObject(filepath, clusterDiameter = 1000,
  existingMeta = NULL)
}
\arguments{
\item{filepath}{absolute path of the WRCC dump file}

\item{clusterDiameter}{diameter in meters used to determine the number of clusters (see \code{addClustering})}

\item{existingMeta}{existing 'meta' dataframe from which to obtain metadata for known monitor deployments}
}
\value{
A \emph{ws_monitor} object with WRCC data.
}
\description{
Ingests a WRCC dump file and converts
it into a quality controlled, metadata enhanced \emph{ws_monitor} object
ready for use with all \code{monitor_~} functions.

Steps involved include:

\enumerate{
 \item{ingest CSV text}
 \item{parse CSV text}
 \item{apply quality control}
 \item{apply clustering to determine unique deployments}
 \item{enhance metadata to include: elevation, timezone, state, country, site name}
 \item{reshape data into deployment-by-property \code{meta} and and time-by-deployment \code{data} dataframes}
}
}
\note{
Each dump file must contain data for only one type of monitor, e.g. EBAM or E-Sampler.
}
\seealso{
\code{\link{wrccDump_parseData}}

\code{\link{wrcc_qualityControl}}

\code{\link{addClustering}}

\code{\link{wrcc_createMetaDataframe}}

\code{\link{wrcc_createDataDataframe}}
}
\keyword{internal}
