% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/imageanalysis.R
\name{raynercolor}
\alias{raynercolor}
\title{Rayner (1970) Fungal Color}
\usage{
raynercolor(fungi)
}
\arguments{
\item{fungi}{Image of fungi in transparent background}
}
\value{
Color name, hue group, and associated fungal pigment
}
\description{
Color matching based on Rayner (1970) nomenclature and association to known fungal pigments
}
\examples{
PUPMCR:::raynercolor(system.file("fungi.png", package = "PUPMCR"))
\dontrun{
raynercolor("fungi_image_format")}
}
\references{
Rayner, R. (1970, ISBN:9780851980263). Mycological Colour Chart. UK: Commonwealth Mycological Insitute and British Mycological Society.

Conlan, X. A., Kalra. R., and Goel M. (2020) <doi:10.3389/fchem.2020.00369> Fungi as a Potential Source of Pigments: Harnessing Filamentous Fungi. Front. Chem, 8:369.

Cejpek, K. and Valisek, J. (2011) <doi:10.17221/524/2010-cjfs> Pigments of Higher Fungi: A review. Czech J. Food Sci., 29:87-102.
}
\author{
Jireh Sealtiel R. Pedrosa

Kristine Joyce P. Rabelas

Charina L. Samontan

Lourdes V. Alvarez

Chester C. Deocaris
}
