% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jovanovicanalysis.R
\name{jovanovicanalysis}
\alias{jovanovicanalysis}
\title{Jovanovic Isotherm Non-Linear Analysis}
\usage{
jovanovicanalysis(Ce, Qe)
}
\arguments{
\item{Ce}{the numerical value for the equilibrium capacity}

\item{Qe}{the numerical value for the adsorpted capacity}
}
\value{
the nonlinear regression, parameters for the Jovanovic isotherm,
and model error analysis
}
\description{
The Jovanovic isotherm model was built upon the assumptions
based on the Langmuir isotherm model with few possible inclusions of
mechanical contact among the desorbing and adsorbing molecules. The adjustment
of the adsorption surface from this model made the equation less effective
in the physical adsorption but can be applied to adsorption with both mobile
and localized monolayer without lateral interaction. Moreover, the equation
of the Jovanovic isotherm model is able to reach the limit of saturation when
there is high concentration, while it reduces to Henry's Law at low concentration.
}
\examples{
Ce <- c(0.01353, 0.04648, 0.13239, 0.27714, 0.41600, 0.63607, 0.80435, 1.10327, 1.58223)
Qe <- c(0.03409, 0.06025, 0.10622, 0.12842, 0.15299, 0.15379, 0.15735, 0.15735, 0.16607)
jovanovicanalysis(Ce, Qe)
}
\references{
:  Saadi, R., Saadi, Z., Fazaeli, R., Fard, N. E. (2015) <DOI: 10.1007/s11814-015-0053-7>
Monolayer and multilayer adsorption isotherm models for sorption from aqueous media.
Korean J. Chem. Eng., 32(5), 787-799 (2015)

:  Vargas, A., Cazetta, A., Kunita, M., Silva, T., Almeida V. (2011) <DOI:10.1016/j.cej.2011.01.067>
Adsorption of methylene blue on activated carbon produced from Flamboyant pods
(Delonix regia): Study of adsorption isotherms and kinetic models. Chemical
Engineering Journal 168 (2011) 722-730
}
\author{
Paul Angelo C. Manlapaz

Chester C. Deocaris
}
