% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/marckzewskijanoirecanalysis.r
\name{mjanalysis}
\alias{mjanalysis}
\title{Marckzewski-Jaroniec Isotherm Analysis Non-Linear Form}
\usage{
mjanalysis(Ce, Qe)
}
\arguments{
\item{Ce}{the numerical value for the equilibrium capacity}

\item{Qe}{the numerical value for the absorbed capacity}
}
\value{
The non-linear regression and the parameters for Marckzewski Jaroniec Isotherm Analysis
}
\description{
The Marczewski-Jaroniec Isotherm model is the resemblance of Langmuir Isotherm model. It is developed on the basis of the supposition of local Langmuir isotherm and adsorption energies distribution in the active sites on adsorbent (Parker, 1995; Sivarajasekar & Baskar, 2014). This equation comprises all isotherm equations being an extension of simple Langmuir Isotherm to single solute adsorption on heterogeneous solids (Marczewski & Jaroniec, 1983).
}
\examples{
mjanalysis(moringa$Ce,moringa$Qe)
}
\references{
Marczewski, A.W., Jaroniec, M. (1983). A new isotherm equation for single-solute adsorption from dilute solutions on energetically heterogeneous solids. Monatsh Chem 114, 711-715. doi: 10.1007/BF01134184

Parker Jr, G.R. (1995). Optimum isotherm equation and thermodynamic interpretation for aqueous 1,1,2- trichloroethene adsorption isotherms on three adsorbents. Adsorption, 1 (2): 113-132. doi:10.1007/BF00705000

Sivarajasekar, N., Baskar, R. (2014). Adsorption of basic red 9 onto activated carbon derived from immature cotton seeds: Isotherm studies and error analysis. Desalination and Water Treatment, 52: 1-23. doi:10.1080/19443994.2013.834518
}
\author{
Brent Mark A. Daniel

Charlestone E. Antatico

C.C. Deocaris
}
