% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pumpresult.R
\name{power_curve}
\alias{power_curve}
\title{Obtain a power curve for a range of sample size or MDES values}
\usage{
power_curve(
  x,
  all = FALSE,
  low = NULL,
  high = NULL,
  grid.size = 5,
  tnum = 2000
)
}
\arguments{
\item{x}{a pumpresult object.}

\item{all}{logical; if TRUE, merge in the search path from the
original search.}

\item{low}{scalar; low range for curve.}

\item{high}{scalar; high range for the curve.}

\item{grid.size}{scalar; number of points to calculate power for.}

\item{tnum}{scalar; number of iterations to calculate power at each
grid point.}
}
\value{
data.frame of power results.
}
\description{
This is used to see how power changes as a function of
  sample size or MDES.  It takes a fit pumpresult and calculates a power
  curve based on that scenario coupled with a passed range of
  values to make the curve over.
}
