% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fcn_qualities.R
\name{qualHighest}
\alias{qualHighest}
\title{Score an empirical density distribution of values, where the best possible distribution is right-skewed.}
\usage{
qualHighest(x, N)
}
\arguments{
\item{x}{Vector of numeric values (e.g. height of histogram bins)}

\item{N}{Length of x (just a precaution currently)}
}
\value{
Quality score in the range of [0,1]
}
\description{
The score is computed according to
}
\details{
q = ((N-1) - sum_i( ((N-i-1)*x_i) ) / (N-1)

Scores range from 0 (worst), to 1 (best).
E.g. c(0,0,0,16) would yield a score of 1.
c(16,0,0,0,0) gives a score of 0.
}
\examples{
 qualHighest(c(0,0,0,16), 4)   ## 1
 qualHighest(c(16,0,0,0), 4)   ## 0 
 qualHighest(c(1,1,1,1), 4)    ## 0.5
 qualHighest(c(0,16,0,0), 4)   ## 1/3
 
}

