% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psf.R
\name{psf}
\alias{psf}
\title{Forecasting of univariate time series using the PSF algorithm}
\usage{
psf(data, n.ahead, k = seq(2, 10), w = seq(1, 10), cycle = 24)
}
\arguments{
\item{data}{Input univariate time series, in any format (time series (ts), vector, matrix, list, data frame).}

\item{n.ahead}{The number of predicted values to be obtained.}

\item{k}{The number of clusters, or a vector of candidate values to search for the optimum automatically.}

\item{w}{The window size, or a vector of candidate values to search for the optimum automatically.}

\item{cycle}{The number of values that conform a cycle in the time series (e.g. 24 hours per day). Only used when input data is not in time series format.}
}
\value{
A list with 3 elements:
\item{predictions}{Vector with the resulting predictions}
\item{k}{Number of clusters used}
\item{w}{Window size used}
}
\description{
Takes an univariate time series and the prediction horizon as inputs.
}
\examples{
## Forecast the next 12 values of the univariate time series: nottem (package:datasets).
psf(nottem, 12)

## Forecast the next 48 values of the univariate time series: sunspots (package:datasets).
psf(sunspots, 48)
}

