% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PPtreeClass.R
\name{PPTreeclass}
\alias{PPTreeclass}
\title{Projection pursuit classification tree}
\usage{
PPTreeclass(formula,data, PPmethod="LDA",weight=TRUE,
                     r=1,lambda=0.1,energy=0,maxiter=50000,...)
}
\arguments{
\item{formula}{an object of class "formula"}

\item{data}{data frame}

\item{PPmethod}{method for projection pursuit; "LDA", "PDA", "Lr", 
"GINI", and "ENTROPY"}

\item{weight}{weight flag in LDA, PDA and Lr index}

\item{r}{r in Lr index}

\item{lambda}{lambda in PDA index}

\item{energy}{parameter for the probability to take new projection}

\item{maxiter}{maximum iteration number}

\item{...}{arguments to be passed to methods}
}
\value{
Tree.Struct tree structure of projection pursuit classification tree

projbest.node 1 dimensional optimal projections of each node split

splitCutoff.node cutoff values of each node split

origclass original class

origdata original data
}
\description{
Construct the projection pursuit classification tree
}
\details{
Find tree structure using various projection pursuit indices of 
classification in each split.
}
\examples{
data(iris)
Tree.result <- PPTreeclass(Species~.,data = iris,"LDA")
Tree.result
}
\references{
Lee, YD, Cook, D., Park JW, and Lee, EK(2013) 
PPtree: Projection Pursuit Classification Tree, 
Electronic Journal of Statistics, 7:1369-1386.
}
\keyword{tree}
