% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paramsPOUMM.R
\name{OU}
\alias{OU}
\alias{dOU}
\alias{meanOU}
\alias{rOU}
\alias{sdOU}
\alias{varOU}
\title{Distribution of an Ornstein-Uhlenbeck Process at Time \eqn{t}, Given 
  Initial State at Time \eqn{0}}
\usage{
dOU(z, z0, t, alpha, theta, sigma, log = TRUE)

rOU(n, z0, t, alpha, theta, sigma)

meanOU(z0, t, alpha, theta)

varOU(t, alpha, sigma)

sdOU(t, alpha, sigma)
}
\arguments{
\item{z}{Numeric value or vector of size n.}

\item{z0}{Numeric value or vector of size n, initial value(s) to condition 
on.}

\item{t}{Numeric value or vector of size n, denoting the time-step.}

\item{alpha, theta, sigma}{Numeric values or n-vectors, parameters of the OU 
process; alpha and sigma must be non-negative. A zero alpha is interpreted 
as the Brownian motion process in the limit alpha -> 0.}

\item{log}{Logical indicating whether the returned density should is on the logarithmic scale.}

\item{n}{Integer, the number of values to sample.}
}
\value{
dOU returns the conditional probability density(ies) of the elements 
  in z, given the initial state(s) z0, time-step(s) t and OU-parameters by
  alpha, theta and sigma.

rOU returns a numeric vector of length n, a random sample from the
  conditional distribution(s) of one or n OU process(es) given initial
  value(s) and time-step(s).

meanOU returns the expected value of the OU-process at time t.

varOU returns the expected variance of the OU-process at time t.

sdOU returns the standard deviation of the OU-process at time t.
}
\description{
An Ornstein-Uhlenbeck (OU) process represents a continuous time 
  Markov chain parameterized by an initial state \eqn{x_0}, selection 
  strength \eqn{\alpha>0}, long-term mean \eqn{\theta}, and time-unit 
  variance \eqn{\sigma^2}. Given \eqn{x_0}, at time \eqn{t}, the state of the
  process is characterized by a normal distribution with mean \eqn{x_0 
  exp(-\alpha t) + \theta (1 - exp(-\alpha t))} and variance \eqn{\sigma^2 
  (1-exp(-2 \alpha t)) / (2 \alpha)}. In the limit \eqn{\alpha -> 0}, the OU 
  process converges to a Brownian motion process with initial state \eqn{x_0}
  and time-unit variance \eqn{\sigma^2} (at time \eqn{t}, this process is 
  characterized by a normal distribution with mean \eqn{x_0} and variance 
  \eqn{t \sigma^2}.
}
\details{
Similar to dnorm and rnorm, the functions described in this
  help-page support single values as well as vectors for the parameters z,
  z0, t, alpha, theta and sigma.
}
\section{Functions}{
\itemize{
\item \code{dOU}: probability density

\item \code{rOU}: random generator

\item \code{meanOU}: mean value

\item \code{varOU}: variance

\item \code{sdOU}: standard deviation
}}
\examples{
z0 <- 8
t <- 10
n <- 100000
sample <- rOU(n, z0, t, 2, 3, 1)
dens <- dOU(sample, z0, t, 2, 3, 1)
var(sample)  # around 1/4
varOU(t, 2, 1) 

}

