% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Dunnett.R
\name{qDunnett}
\alias{qDunnett}
\alias{Dunnett}
\alias{pDunnett}
\title{Dunnett Distribution}
\usage{
qDunnett(p, n0, n)

pDunnett(q, n0, n, lower.tail = TRUE)
}
\arguments{
\item{p}{vector of probabilities.}

\item{n0}{sample size for control group.}

\item{n}{vector of sample sizes for treatment groups.}

\item{q}{vector of quantiles.}

\item{lower.tail}{logical; if TRUE (default),
probabilities are \eqn{P[X \leq x]} otherwise, \eqn{P[X > x]}.}
}
\value{
\code{pDunnett} gives the distribution function and
\code{qDunnett} gives its inverse, the quantile function.
}
\description{
Distribution function and quantile function
for the distribution of Dunnett's many-to-one
comparisons test.
}
\details{
Dunnett's distribution is a special case of the
multivariate t distribution.

Let the total sample size be \eqn{N = n_0 + \sum_i^m n_i}, with \eqn{m} the
number of treatment groups, than the quantile \eqn{T_{m v \rho \alpha}}
is calculated with \eqn{v = N - k} degree of freedom and
the correlation \eqn{\rho}

\deqn{
 \rho_{ij} = \sqrt{\frac{n_i n_j}
             {\left(n_i + n_0\right) \left(n_j+ n_0\right)}} ~~
             (i \ne j).
}

The functions determines \eqn{m} via the length of the input
vector \code{n}.

Quantiles and p-values are computed with the functions
of the package \strong{mvtnorm}.
}
\note{
The results are seed depending.
}
\examples{
## Table gives 2.34 for df = 6, m = 2, one-sided
set.seed(112)
qval <- qDunnett(p = 0.05, n0 = 3, n = rep(3,2))
round(qval, 2)
set.seed(112)
pDunnett(qval, n0=3, n = rep(3,2), lower.tail = FALSE)

## Table gives 2.65 for df = 20, m = 4, two-sided
set.seed(112)
qval <- qDunnett(p = 0.05/2, n0 = 5, n = rep(5,4))
round(qval, 2)
set.seed(112)
2 * pDunnett(qval, n0= 5, n = rep(5,4), lower.tail= FALSE)
}
\seealso{
\code{\link[mvtnorm]{qmvt}} \code{\link[mvtnorm]{pmvt}} \code{\link{dunnettTest}}
}
