% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adKSampleTest.R
\name{adKSampleTest}
\alias{adKSampleTest}
\alias{adKSampleTest.default}
\alias{adKSampleTest.formula}
\title{Anderson-Darling k-Sample Test}
\usage{
adKSampleTest(x, ...)

\method{adKSampleTest}{default}(x, g, ...)

\method{adKSampleTest}{formula}(formula, data, subset, na.action, ...)
}
\arguments{
\item{x}{a numeric vector of data values, or a list of numeric data
vectors.}

\item{\dots}{further arguments to be passed to or from methods.}

\item{g}{a vector or factor object giving the group for the
corresponding elements of \code{"x"}.
Ignored with a warning if \code{"x"} is a list.}

\item{formula}{a formula of the form \code{response ~ group} where
\code{response} gives the data values and \code{group} a vector or
factor of the corresponding groups.}

\item{data}{an optional matrix or data frame (or similar: see
\code{\link{model.frame}}) containing the variables in the
formula \code{formula}.  By default the variables are taken from
\code{environment(formula)}.}

\item{subset}{an optional vector specifying a
subset of observations to be used.}

\item{na.action}{a function which indicates what should happen when
the data contain \code{NA}s.  Defaults to \code{getOption("na.action")}.}
}
\value{
A list with class \code{"htest"} containing the following components:
\describe{
\item{method}{a character string indicating what type of test was performed.}
\item{data.name}{a character string giving the name(s) of the data.}
\item{statistic}{the estimated quantile of the test statistic.}
\item{p.value}{the p-value for the test.}
\item{parameter}{the parameters of the test statistic, if any.}
\item{alternative}{a character string describing the alternative hypothesis.}
\item{estimates}{the estimates, if any.}
\item{null.value}{the estimate under the null hypothesis, if any.}
}
}
\description{
Performs Anderson-Darling k-sample test.
}
\details{
The null hypothesis, H\eqn{_0: F_1 = F_2 = \ldots = F_k}
is tested against the alternative,
H\eqn{_\mathrm{A}: F_i \ne F_j ~~(i \ne j)}, with at least
one unequality beeing strict.

This function only evaluates version 1 of the k-sample Anderson-Darling
test (i.e. Eq. 6) of Scholz and Stephens (1987).
The p-values are estimated with the extended empirical function
as implemented in \code{\link[kSamples]{ad.pval}} of
the package \pkg{kSamples}.
}
\examples{
## Hollander & Wolfe (1973), 116.
## Mucociliary efficiency from the rate of removal of dust in normal
## subjects, subjects with obstructive airway disease, and subjects
## with asbestosis.
x <- c(2.9, 3.0, 2.5, 2.6, 3.2) # normal subjects
y <- c(3.8, 2.7, 4.0, 2.4)      # with obstructive airway disease
z <- c(2.8, 3.4, 3.7, 2.2, 2.0) # with asbestosis
g <- factor(x = c(rep(1, length(x)),
                   rep(2, length(y)),
                   rep(3, length(z))),
             labels = c("ns", "oad", "a"))
dat <- data.frame(
   g = g,
   x = c(x, y, z))

## AD-Test
adKSampleTest(x ~ g, data = dat)

## BWS-Test
bwsKSampleTest(x ~ g, data = dat)

## Kruskal-Test
## Using incomplete beta approximation
kruskalTest(x ~ g, dat, dist="KruskalWallis")
## Using chisquare distribution
kruskalTest(x ~ g, dat, dist="Chisquare")

\dontrun{
## Check with kruskal.test from R stats
kruskal.test(x ~ g, dat)
}
## Using Conover's F
kruskalTest(x ~ g, dat, dist="FDist")

\dontrun{
## Check with aov on ranks
anova(aov(rank(x) ~ g, dat))
## Check with oneway.test
oneway.test(rank(x) ~ g, dat, var.equal = TRUE)
}
}
\references{
Scholz, F.W., Stephens, M.A. (1987) K-Sample Anderson-Darling Tests.
\emph{Journal of the American Statistical Association} \bold{82}, 918--924.
}
\seealso{
\code{\link{adAllPairsTest}}, \code{\link{adManyOneTest}},
\code{\link[kSamples]{ad.pval}}.
}
\keyword{htest}
\keyword{nonparametric}
