% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cochranTest.R
\name{cochranTest}
\alias{cochranTest}
\alias{cochranTest.default}
\alias{cochranTest.formula}
\title{Cochran Test}
\usage{
cochranTest(x, ...)

\method{cochranTest}{default}(x, g, alternative = c("greater", "less"), ...)

\method{cochranTest}{formula}(formula, data, subset, na.action,
  alternative = c("greater", "less"), ...)
}
\arguments{
\item{x}{a numeric vector of data values, or a list of numeric data
vectors.}

\item{\dots}{further arguments to be passed to or from methods.}

\item{g}{a vector or factor object giving the group for the
corresponding elements of \code{"x"}.
Ignored with a warning if \code{"x"} is a list.}

\item{alternative}{the alternative hypothesis. Defaults to \code{"greater"}}

\item{formula}{a formula of the form \code{response ~ group} where
\code{response} gives the data values and \code{group} a vector or
factor of the corresponding groups.}

\item{data}{an optional matrix or data frame (or similar: see
\code{\link{model.frame}}) containing the variables in the
formula \code{formula}.  By default the variables are taken from
\code{environment(formula)}.}

\item{subset}{an optional vector specifying a 
subset of observations to be used.}

\item{na.action}{a function which indicates what should happen when
the data contain \code{NA}s.  Defaults to \code{getOption("na.action")}.}
}
\value{
A list with class \code{"htest"} containing the following components:
\describe{
 \item{method}{a character string indicating what type of test was performed.}
 \item{data.name}{a character string giving the name(s) of the data.}
 \item{statistic}{the estimated quantile of the test statistic.}
 \item{p.value}{the p-value for the test.}
 \item{parameter}{the parameters of the test statistic, if any.}
 \item{alternative}{a character string describing the alternative hypothesis.}
\item{estimates}{the estimates, if any.}
\item{null.value}{the estimate under the null hypothesis, if any.}
}
}
\description{
Performs Cochran's test for testing an outlying (or inlying)
variance.
}
\details{
For normally distributed data the null hypothesis,
H\eqn{_0: \sigma_1^2 = \sigma_2^2 = \ldots = \sigma_k^2}
is tested against the alternative (greater)
H\eqn{_{\mathrm{A}}: \sigma_p > \sigma_i ~~ (i \le k, i \ne p)} with
at least one inequality being strict.

The p-value is computed with the function \code{\link{pcochran}}.
}
\examples{
data(Pentosan)
cochranTest(value ~ lab, data = Pentosan, subset = (material == "A"))

}
\references{
Cochran, W.G. (1941) The distribution of the largest of a set of estimated
variances as a fraction of their total. \emph{Ann. Eugen.} \bold{11}, 47--52.

Wilrich, P.-T. (2011) Critical values of Mandel's h and k,
Grubbs and the Cochran test statistic. \emph{Adv. Stat. Anal.}.
\url{http://dx.doi.org/10.1007/s10182-011-0185-y}.
}
\seealso{
\code{\link[stats]{bartlett.test}}, \code{\link[stats]{fligner.test}}.
}
\concept{
outlier
}
\keyword{htest}
