% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PLNPCA.R
\name{PLNPCA}
\alias{PLNPCA}
\title{Poisson lognormal model towards Principal Component Analysis}
\usage{
PLNPCA(formula, data, subset, weights, ranks = 1:5,
  control_init = list(), control_main = list())
}
\arguments{
\item{formula}{an object of class "formula": a symbolic description of the model to be fitted.}

\item{data}{an optional data frame, list or environment (or object coercible by as.data.frame to a data frame) containing the variables in the model. If not found in data, the variables are taken from environment(formula), typically the environment from which lm is called.}

\item{subset}{an optional vector specifying a subset of observations to be used in the fitting process.}

\item{weights}{an optional vector of weights to be used in the fitting process. Should be NULL or a numeric vector.}

\item{ranks}{a vector of integer containing the successive ranks (or number of axes to be considered)}

\item{control_init}{a list for controling the optimization at initialization.  See details of function \code{\link[=PLN]{PLN}}.}

\item{control_main}{a list for controling the main optimization process. See details.}
}
\value{
an R6 object with class \code{\link[=PLNPCAfamily]{PLNPCAfamily}}, which contains
a collection of models with class \code{\link[=PLNPCAfit]{PLPCAfit}}
}
\description{
Fit the PCA variants of the Poisson lognormal with a variational algorithm. Use the (g)lm syntax for model specification (covariates, offsets).
}
\details{
The list of parameters \code{control_main} controls the optimization of the main process, with the following entries
\itemize{
 \item{"ftol_rel"}{stop when an optimization step changes the objective function by less than ftol multiplied by the absolute value of the parameter. Default is 1e-8}
 \item{"ftol_abs"}{stop when an optimization step changes the objective function by less than ftol multiplied by the absolute value of the parameter. Default is 0}
 \item{"xtol_rel"}{stop when an optimization step changes every parameters by less than xtol multiplied by the absolute value of the parameter. Default is 1e-4}
 \item{"xtol_abs"}{stop when an optimization step changes every parameters by less than xtol multiplied by the absolute value of the parameter. Default is 1e-4}
 \item{"lower_bound"}{the lower bound (box constraint) for the variational variance parameters. Default is 1e-4.}
 \item{"maxeval"}{stop when the number of iteration exceeds maxeval. Default is 10000}
 \item{"maxtime"}{stop when the optimization time (in seconds) exceeds maxtime. Default is -1 (no restriction)}
 \item{"algorithm"}{the optimization method used by NLOPT among LD type, i.e. "CCSAQ", "MMA", "LBFGS",
    "VAR1", "VAR2". See NLOPT documentation for further details. Default is "CCSAQ".}
 \item{"trace"}{integer for verbosity. Useless when \code{cores} > 1}
 \item{"cores"}{The number of core used to paralellize jobs over the \code{ranks} vector. Default is 1.}
}
}
\examples{
data(trichoptera)
trichoptera <- prepare_data(trichoptera$Abundance, trichoptera$Covariate)
myPCA <- PLNPCA(Abundance ~ 1 + offset(log(Offset)), data = trichoptera, ranks = 1:5)
}
\seealso{
The classes \code{\link[=PLNPCAfamily]{PLNPCAfamily}} and \code{\link[=PLNPCAfit]{PLNPCAfit}}
}
