% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interpolate.conc.R
\name{interp.extrap.conc}
\alias{extrapolate.conc}
\alias{interp.extrap.conc}
\alias{interpolate.conc}
\title{Interpolate concentrations between measurements or extrapolate
concentrations after the last measurement.}
\usage{
interp.extrap.conc(conc, time, time.out, lambda.z = NA,
  clast = pk.calc.clast.obs(conc, time), options = list(),
  interp.method = PKNCA.choose.option("auc.method", options),
  extrap.method = "AUCinf", conc.blq = PKNCA.choose.option("conc.blq",
  options), conc.na = PKNCA.choose.option("conc.na", options), check = TRUE)

interpolate.conc(conc, time, time.out, options = list(),
  interp.method = PKNCA.choose.option("auc.method", options),
  conc.blq = PKNCA.choose.option("conc.blq", options),
  conc.na = PKNCA.choose.option("conc.na", options), check = TRUE)

extrapolate.conc(conc, time, time.out, lambda.z = NA,
  clast = pk.calc.clast.obs(conc, time), extrap.method = "AUCinf",
  options = list(), conc.na = PKNCA.choose.option("conc.na", options),
  conc.blq = PKNCA.choose.option("conc.blq", options), check = TRUE)
}
\arguments{
\item{conc}{Measured concentrations}

\item{time}{Time of the concentration measurement}

\item{time.out}{Time when interpolation is requested (vector for
\code{interp.extrap.conc}, scalar otherwise)}

\item{lambda.z}{The elimination rate constant.  \code{NA} will
prevent extrapolation.}

\item{clast}{The last observed concentration above the limit of
quantification.  If not given, \code{clast} is calculated from \code{\link{pk.calc.clast.obs}}}

\item{options}{List of changes to the default
\code{\link{PKNCA.options}} for calculations.}

\item{interp.method}{The method for interpolation (either
'lin up/log down' or 'linear')}

\item{extrap.method}{The method for extrapolation: "AUCinf",
"AUClast", or "AUCall".  See details for usage.}

\item{conc.blq}{How to handle BLQ values. (See
\code{\link{clean.conc.blq}} for usage instructions.)}

\item{conc.na}{How to handle NA concentrations.  (See
\code{\link{clean.conc.na}})}

\item{check}{Run \code{\link{check.conc.time}},
\code{\link{clean.conc.blq}}, and \code{\link{clean.conc.na}}?}
}
\value{
The interpolated or extrapolated concentration value as a
scalar float.
}
\description{
\code{interpolate.conc} and \code{extrapolate.conc} returns an
interpolated (or extrapolated) concentration.
\code{interp.extrap.conc} will choose whether interpolation or
extrapolation is required and will also operate on many
concentrations.  These will typically be used to estimate the
concentration between two measured concentrations or after the last
measured concentration.  Of note, these functions will not
extrapolate prior to the first point.
}
\details{
\describe{
  \item{extrap.method}{
    \describe{
      \item{'AUCinf'}{Use lambda.z to extrapolate beyond the last
        point with the half-life.}
      \item{'AUCall'}{If the last point is above the limit of
        quantification or missing, this is identical to 'AUCinf'.
        If the last point is below the limit of quantification,
        then linear interpolation between the Clast and the next
        BLQ is used for that interval and all additional points
        are extrapolated as 0.}
      \item{'AUClast'}{Extrapolates all points after the last above
        the limit of quantification as 0.}
    }
  }
}
}
\section{Functions}{
\itemize{
\item \code{interpolate.conc}: Interpolate concentrations through
Tlast (inclusive)

\item \code{extrapolate.conc}: Extrapolate concentrations after Tlast
}}
\seealso{
\code{\link{pk.calc.clast.obs}}
\code{\link{pk.calc.half.life}}
}

