% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auc_integrate.R
\name{choose_interval_method}
\alias{choose_interval_method}
\title{Choose how to interpolate, extrapolate, or integrate data in each
concentration interval}
\usage{
choose_interval_method(conc, time, tlast, method, auc.type, options)
}
\arguments{
\item{conc}{Measured concentrations}

\item{time}{Time of the measurement of the concentrations}

\item{tlast}{Time of last concentration above the limit of quantification
(will be calculated, if not provided)}

\item{method}{The method for integration (one of 'lin up/log down',
'lin-log', or 'linear')}

\item{auc.type}{The type of AUC to compute.  Choices are 'AUCinf', 'AUClast',
and 'AUCall'.}

\item{options}{List of changes to the default PKNCA options (see
\code{PKNCA.options()})}
}
\value{
A character vector of methods for interpolation/extrapolation
methods that is the same length as \code{conc} which indicates how to
interpolate/integrate between each of the concentrations (all but the last
value in the vector) and how to extrapolate after \code{tlast} (the last item in
the vector).  Possible values in the vector are: 'zero', 'linear', 'log',
and 'extrap_log'
}
\description{
Choose how to interpolate, extrapolate, or integrate data in each
concentration interval
}
\keyword{Internal}
