% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simcode.R
\name{simcode}
\alias{simcode}
\title{Simulate Weibull survival data from a model, perform reduction to remove infinite estimates, and calculate p values.}
\usage{
simcode(
  dataset,
  myformula,
  iv,
  ctime,
  nsamp = 10000,
  add = NULL,
  nobs = NA,
  half = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{dataset}{the data set to use}

\item{myformula}{the formula for the Cox regression}

\item{iv}{name of the variable of interest, as a character string}

\item{ctime}{fixed censoring time}

\item{nsamp}{number of samples.}

\item{add}{preliminary results, if any.}

\item{nobs}{number of observations in target models, if different from that of dataset.}

\item{half}{logical flag triggering a less extreme simulation by dividing the Weibull regression parameters in half.}

\item{verbose}{logical flag triggering intermediate messaging.}
}
\value{
a list with components
\itemize{
  \item out matrix with columns corresponding to p-values.
  \item seed random seed
  \item bad unused.
  \item srreg parametric lifetime regression
}
}
\description{
Operating characteristics for the approximate conditional inferential approach to proportional hazards.
}
\details{
This function is intended to verify the operating characteristics of the approximate conditional inferential approach of \insertCite{kz19;textual}{PHInfiniteEstimates} to proportional hazards regression.  A Weibull regression model, corresponding to the proportional hazards regression model, is fit to the data, and new data sets are simulated from this model.  P-values are calculated for these new data sets, and their empirical distribution is compared to the theoretical uniform distribution.
}
\examples{
data(breast)
\donttest{
breasttestp<-simcode(breast,Surv(TIME,CENS)~ T+ N+ G+ CD,"T",72,nsamp=100,verbose=TRUE)
}
}
\references{
\insertRef{kz19}{PHInfiniteEstimates}
}
