% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convertbaselineltolr.R
\name{convertbaselineltolr}
\alias{convertbaselineltolr}
\title{Convert a baseline logit model data set, formatted in the long form as described in the documentation for mlogit.data from mlogit package, to a conditional logistic regression.}
\usage{
convertbaselineltolr(dataset, choice, covs, strs = "chid", alt = "alt")
}
\arguments{
\item{dataset}{in formatted as in the output from mlogit.data of the mlogit packages}

\item{choice}{name of variable in dataset representing choice, a logical variable indicating whether this choice is actually chosen.}

\item{covs}{vector of names of covariates}

\item{strs}{name of variable in data set indicating independent subject}

\item{alt}{name of variable in data set indicating potential choice.}
}
\value{
a data set on which to apply conditional logistic regression, corresponding to the baseline logit model.
}
\description{
Convert a baseline logit model data set, formatted in the long form as described in the documentation for mlogit.data from mlogit package, to a conditional logistic regression.
}
\details{
This function implements version of \insertCite{kolassa16}{PHInfiniteEstimates}.
The multinomial regression is converted to a conditional logistic regression, and methods of \insertCite{kolassa97}{PHInfiniteEstimates} may be applied.  
This function differs from \code{convertmtol} of this package in that \code{convertmtol} treats a less-rich data structure, and this function treats the richer data structure that is an output of \code{mlogit.data} from package \code{mlogit}.
Data in the example is from \insertCite{bes;textual}{PHInfiniteEstimates}.
}
\examples{
data(voter.ml)
#Add the index attribute to the data set, giving the index of choice made and the index of the 
#alternative, and a boolean variable giving choice.
attributes(voter.ml)$index<-voter.ml[,c("chid","alt")]
attributes(voter.ml)$choice<-"voter"
covs<-c("Labor","Liberal.Democrat","education")
strs<-"chid"
alt<-"alt"
#Fit the multinomial regression model, for comparison purposes.
mlogit(voter~1|Labor+Liberal.Democrat+education,data=voter.ml)
#Convert to a data set allowing treatment as the equivalent conditional logistic regression.  
#This result will be processed using reduceLR of this package to give an equivalent conditional
# regression model avoiding infinite estimates.
out<-convertbaselineltolr(voter.ml,"voter",c("Labor","Liberal.Democrat","education"))
#Fit the associated unconditional logistic regression for comparison purposes.
glm(out[,"y"]~out[,1:75],family=binomial)
}
\references{
\insertRef{bes}{PHInfiniteEstimates}

\insertRef{kolassa97}{PHInfiniteEstimates}

\insertRef{kolassa16}{PHInfiniteEstimates}
}
