% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrix.p.null.R
\encoding{UTF-8}
\name{matrix.p.null}
\alias{matrix.p.null}
\title{Auxiliar function to generate sets of null P matrix or null PCPS}
\usage{
matrix.p.null(
  comm,
  phylodist,
  runs = NULL,
  calcpcps = FALSE,
  method = "bray",
  squareroot = TRUE,
  adjpcps = FALSE,
  choices = NULL
)
}
\arguments{
\item{comm}{Community data, with species as columns and sampling units as rows. This matrix 
can contain either presence/absence or abundance data.}

\item{phylodist}{Matrix containing phylogenetic distances between species.}

\item{runs}{Number of matrix will be generated (Default runs = NULL).}

\item{calcpcps}{Logical argument (TRUE or FALSE) to specify if generate the PCPS (Default calcpcps = FALSE).}

\item{method}{Dissimilarity index, as accepted by \code{\link{vegdist}} (Default dist = "bray").}

\item{squareroot}{Logical argument (TRUE or FALSE) to specify if use square root of 
dissimilarity index (Default squareroot = TRUE).}

\item{adjpcps}{Logical argument (TRUE or FALSE) to specify if return fitted PCPS (Default adjpcps = FALSE).}

\item{choices}{Numeric vector to choose the PCPS to adjust (Default pcps.choices = NULL).}
}
\value{
\item{call}{The arguments used.}
\item{P.obs}{Observed phylogeny-weighted species composition matrix.}
\item{pcps.obs}{Observed principal coordinates of phylogenetic structure (PCPS).}
\item{permutation.site}{A matrix with sequence of permutation for site shuffle null model, each permutation in one row.}
\item{permutation.taxa}{A matrix with sequence of permutation for taxa shuffle null model, each permutation in one row.}
\item{P.null.site}{A list with each permuted P matrix according with site shuffle null model.}
\item{P.null.taxa}{A list with each permuted P matrix according with taxa shuffle null model.}
\item{pcps.null.site}{A list with each permuted PCPS according with site shuffle null model.}
\item{pcps.null.taxa}{A list with each permuted PCPS according with taxa shuffle null model.}
\item{pcps.null.taxa.adj}{A list with each permuted PCPS (adjusted) according with taxa shuffle null model.}
}
\description{
Auxiliar function to generate sets of null P matrix or null PCPS used 
in \code{\link{matrix.p.sig}} or \code{\link{pcps.sig}}. The result are long lists with 
permuted matrices.
}
\seealso{
\code{\link{matrix.p}}, \code{\link{pcps}}, \code{\link{matrix.p.sig}}, \code{\link{pcps.sig}}
}
\author{
Vanderlei Julio Debastiani <vanderleidebastiani@yahoo.com.br>
}
\keyword{PCPS}
