% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{get_indices}
\alias{get_indices}
\title{Retrieve indices for a rolling window analysis}
\usage{
get_indices(y_var, window_size = 15L)
}
\arguments{
\item{y_var}{NumericVector. Input on which to define the indices for each roll of
the window}

\item{window_size}{int. The size of the window}
}
\value{
a list in which each element contains \code{window_size} consecutive
  integers that indicate which elements of \code{y_var} would be extracted
  for that roll of the window
}
\description{
Retrieve indices for a rolling window analysis
}
\note{
For this function, the output elements contain positions (i.e., indices) from
  \code{y_var}, whereas for \code{\link{rolling_groups}} the output elements
  contain the raw values found at each index
}
\examples{
result <- get_indices(1:100, 10)
head(result)
tail(result)
}
\seealso{
\code{\link{rolling_groups}}
}
