% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addMeasures.R
\name{addMeasures}
\alias{addMeasures}
\alias{getMeasures}
\title{Add Measures}
\usage{
addMeasures(x, measures, replace = TRUE)

getMeasures(x)
}
\arguments{
\item{x}{an \linkS4class{AcousticStudy} or
\linkS4class{AcousticEvent} object}

\item{measures}{the measures to add. Can either be a named list,
where names match event names of \code{x} or a dataframe with
column \code{eventId} matching the event names of \code{x}. If
a list, every item within the list must also be named by the
variable name. All
other data within \code{measures} will be added as new measures}

\item{replace}{logical flag whether or not to replace}
}
\value{
object of same class as \code{x} with measures added
}
\description{
Adds "measures" to an AcousticStudy or AcousticEvent.
  A "measure" is an event-level variable that will be exported
  alongside data from that event
}
\examples{

data(exStudy)
measList <- list('Example.OE1' = list(a=1, b=2),
                 'Example.OE2' = list(a=2, b=3)
                 )
exMeasure <- addMeasures(exStudy, measList)
print(getMeasures(exMeasure))
measDf <- data.frame(eventId = c('Example.OE1', 'Example.OE2'),
                     a=4:5,
                     b=6:7)
exMeasure <- addMeasures(exMeasure, measDf, replace=TRUE)
getMeasures(exMeasure)

}
\author{
Taiki Sakai \email{taiki.sakai@noaa.gov}
}
