% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PAMA.F.R
\name{PAMA.F}
\alias{PAMA.F}
\title{This function implements Maximum Likelihood estimation of PAMA model.}
\usage{
PAMA.F(datfile, nRe, threshold, iter = 1000)
}
\arguments{
\item{datfile}{A matrix or dataframe. This is the data where our algorithm will work on. Each row denotes a ranker's ranking. The data should be in entity-based format.}

\item{nRe}{A number. Number of relevant entities.}

\item{threshold}{A number(positive). The stopping threshold in determining convergence of MLE. if the two consecutive iterations of log-likelihood is smaller than threshold, then the convergence achives.}

\item{iter}{A number. Numner of iterations of MCMC.}
}
\value{
List. It contains MLE of all the parameters and log-likelihood.
\enumerate{
\item I.mat:  samples of I
\item phi.mat:  samples of phi.
\item smlgamma.mat:  samples of gamma
\item l.mat:  samples of log-likelihood
}
}
\description{
This function implements Maximum Likelihood estimation of PAMA model.
}
\examples{
a=NBANFL()
PAMA.F(a$NBA,nRe=10,threshold=0.1,iter=100)
}
