% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/offsetGridText.R
\name{offsetGridText}
\alias{offsetGridText}
\title{Insert offset text annotation into 'trellis' plot}
\usage{
offsetGridText(x, y = NULL, labels, xlim = NULL, ylim = NULL,
  pos = NULL, stext = FALSE, offset = 0.02, ...)
}
\arguments{
\item{x}{A \code{numeric} vector containing x coordinates, or a 2-column
\code{matrix} containing x and y coordinates.}

\item{y}{A \code{numeric} vector containing y coordinates, or \code{NULL} 
if 'x' is a two-column \code{matrix}.}

\item{labels}{The text to be written as \code{character}.}

\item{xlim, ylim}{X and Y-axis limits (\code{c(min, max)}) of the current plot. 
If not supplied, limits are automatically calculated from supplied x and y
coordinates.}

\item{pos}{Text position specifier(s) as \code{integer} used by 
\code{\link{text}}. If not supplied, optimal text positions will be 
determined with respect to neighboring locations using 
\code{\link[plotrix]{thigmophobe}}.}

\item{stext}{\code{logical}, defaults to \code{FALSE}. If \code{TRUE}, shadow 
text will be drawn around 'labels'.}

\item{offset}{A \code{numeric} offset in normalized parent coordinates
("npc", see \code{\link[grid]{unit}}).}

\item{...}{Additional arguments passed to the respective \strong{grid} text 
drawing function (depends on 'stext').}
}
\description{
This is a wrapper function around \code{Orcs:::calcOffsetGridText} and 
\strong{grid}-based text drawing functions (currently including 
\code{\link{grid.text}} and \code{\link{grid.stext}}) that automatically adds
offset text annotations to a 'trellis' plot.
}
\examples{
stopifnot(
  require(sf)
  , require(latticeExtra)
  , require(grid)
)

# kilimanjaro peaks
peaks = data.frame(Peak = c("Kibo", "Mawenzi", "Shira")
                   , Lon = c(37.359031, 37.455061, 37.210408)
                   , Lat = c(-3.065053, -3.095436, -3.038222))

coordinates(peaks) = ~ Lon + Lat
proj4string(peaks) = "+init=epsg:4326"

# visualization
xlim_kili <- c(37.15, 37.55)
ylim_kili <- c(-3.25, -2.9)

p = spplot(KiLi[[1]], col.regions = "transparent", colorkey = FALSE, 
           xlim = xlim_kili, ylim = ylim_kili,
           scales = list(draw = TRUE, y = list(rot = 90)), 
           sp.layout = rgb2spLayout(KiLi, quantiles = c(0, 1), alpha = .8)) + 
  layer(sp.points(peaks, cex = 1.5, pch = 20, col = "black"))

print(p)

downViewport(trellis.vpname(name = "figure"))
offsetGridText(x = coordinates(peaks), labels = peaks$Peak,  
               xlim = xlim_kili, ylim = ylim_kili, stext = TRUE, offset = .02,
               gp = gpar(fontsize = 16))
                               
}
\seealso{
\code{\link[grid]{grid.text}}, \code{\link{grid.stext}}, 
\code{\link[plotrix]{thigmophobe}}, \code{Orcs::calcOffsetGridText}.
}
\author{
Florian Detsch
}
