optimal.cutpoints <-
function(methods, data, marker, status, tag.healthy, 
categorical.cov = NULL, pop.prev = NULL, control = control.cutpoints(), ci.fit = FALSE, conf.level = 0.95, trace = TRUE) {
       
	if(missing(methods) || is.null(methods)) {
    		stop("'methods' argument required.", call.=FALSE)
    	}
    	if(any(!(methods %in% c("CB","MCT","MinValueSp","MinValueSe","RangeSp","RangeSe","ValueSp","ValueSe","MinValueSpSe","MaxSp","MaxSe","MaxSpSe",
		"MaxSumSpSe","MaxProdSpSe","ROC01","SpEqualSe","Youden","MaxEfficiency","Minimax","AUC","MaxDOR","MaxKappa","MaxAccuracyArea","MinErrorRate",
		"MinValueNPV","MinValuePPV","MinValueNPVPPV","PROC01","NPVEqualPPV","ValueDLR.Negative","ValueDLR.Positive","MinPvalue","ObservedPrev","MeanPrev","PrevalenceMatching")))) {
		stop ("You have entered an invalid method.", call. = FALSE)
    	}
    	if (missing(data)|| is.null(data))
    	{
      	stop("'data' argument required.", call. = FALSE)
    	}
    	if (missing(marker)|| is.null(marker))
    	{
      	stop("'marker' argument required.", call. = FALSE)
    	}
    	if (missing(status)|| is.null(status))
    	{
      	stop("'status' argument required.", call. = FALSE)
    	}
    	if (missing(tag.healthy)|| is.null(tag.healthy))
    	{
      	stop("'tag.healthy' argument required.", call. = FALSE)
    	}
    	if (is.logical(ci.fit) == FALSE) {
      	stop("'ci.fit' must be a logical-type argument.", call. = FALSE)
    	}    
    	if (conf.level < 0 | conf.level > 1 | length(conf.level) != 1)
    	{
      	stop("'conf.level' must be a single number between 0 and 1.", call. = FALSE)
    	}
    	if (is.logical(trace) == FALSE) {
        	stop("'trace' must be a logical-type argument.", call. = FALSE)
    	}
    	if (is.null(pop.prev) & ci.fit == TRUE & !control$ci.PV %in% c("Exact","Quadratic","Wald","AgrestiCoull","RubinSchenker"))
    	{
      	warning ("You have entered an invalid method for computing the confidence intervals \n of the Predictive Values. Prevalence is estimated from the sample. \n", call. = FALSE)      	 
    	}
    	if (!is.null(pop.prev) & ci.fit == TRUE & !control$ci.PV %in% c("Transformed","NotTransformed","GartNam"))
    	{
      	warning ("You have entered an invalid method for computing the confidence intervals \n of the Predictive Values. Prevalence is not estimated from the sample. \n", call. = FALSE)
    	}
        
    	# NA's deleted
    	data <- na.omit(data[,c(marker,status,categorical.cov)])
    	# A data frame with the results is created:
    	res <- vector("list", length(methods))
    	names(res) <- methods
    	# Categorical covariate levels:     	
    	if(!is.null(categorical.cov)) {
    		if(!is.factor(data[, categorical.cov])) data[, categorical.cov] <- factor(data[, categorical.cov])
        	data[, categorical.cov] <- droplevels(data[, categorical.cov])
        	levels.cat <- levels(data[, categorical.cov])            
        	for (i in 1: length(methods)) {
            	res[[i]] <- vector("list", length(levels.cat))
            	names(res[[i]]) <- levels.cat
        	}        
    	} else {
    		levels.cat = 1
    		res[[1]] <- vector("list", 1)
    		names(res[[1]]) <- "Global"
    	}
    	pop.prev.new <- vector(length=length(levels(data[, categorical.cov])))
    	if(is.null(pop.prev)) pop.prev <- NA
    	if (!is.null(categorical.cov) & length(pop.prev) != 1 & length(pop.prev) != length(levels(data[, categorical.cov]))) {
    		stop("You have entered different values for prevalence which \n do not coincide with categorical covariate levels.", call. = FALSE)
   		}
    	else if (!is.null(categorical.cov) & length(pop.prev) == 1)
    	{
      	pop.prev.new <- rep(pop.prev, length(levels(data[, categorical.cov])))                 
    	}
    	else if (is.null(categorical.cov) & length(pop.prev) > 1)
    	{
     		warning("You have entered several values for prevalence. \n The first value has been selected.", call. = FALSE, immediate. = TRUE)     		
     		pop.prev.new <- pop.prev[1]            
    	}
    	else 
    	{
      	pop.prev.new <- pop.prev
    	}
    	# Each method is called up:      	
    	for (i in 1: length(methods)) {
      	for(j in 1:length(levels.cat)) { 
        		if(trace) {
        			cat("*************************************************\n")
        			text <- paste("Method: ", methods[i], sep = "")
        			if(length(levels.cat) > 1) {
        		 		text <- paste(text, ". Level: ", levels.cat[j], sep = "")
        			}
        			cat(text)
        			cat("\nAnalysing ...")
        			cat("\n*************************************************\n")                      
        		}	
            	data.m <- if(length(levels.cat) != 1) data[data[,categorical.cov] == levels.cat[j], ] else data
            	if (is.na(pop.prev.new[j])) {
        			pop.prev.new[j] <- calculate.sample.prev(data.m, status, tag.healthy)
    			}
    			validate.prevalence(pop.prev.new[j])    
            	res[[i]][[j]] <- eval(parse(text = paste("function.", methods[i], sep = "")))(data = data.m, marker = marker, status = status, tag.healthy = tag.healthy, pop.prev = pop.prev.new[j], control = control, conf.level = conf.level, ci.fit = ci.fit)
        	}
    	}
    	res$methods <-  methods
    	if(length(levels.cat) != 1) res$levels.cat  <-  levels.cat
    	res$call <- match.call()
    	res$data <- data
    	class(res) <- "optimal.cutpoints"
    	invisible(res)
    	res
}
