% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opentree_taxonomy.R
\name{get_ott_clade}
\alias{get_ott_clade}
\title{Get the Open Tree of Life Taxonomic identifiers (OTT ids) and name of one or
several given taxonomic ranks from one or more input taxa.}
\usage{
get_ott_clade(input = NULL, ott_ids = NULL, ott_rank = "family")
}
\arguments{
\item{input}{Optional. A character vector of names.}

\item{ott_ids}{If not NULL, it takes this argument and ignores input. A
numeric vector of ott ids obtained with \code{\link[rotl:taxonomy_taxon_info]{rotl::taxonomy_taxon_info()}} or
\code{\link[rotl:tnrs_match_names]{rotl::tnrs_match_names()}} or \code{\link[=tnrs_match]{tnrs_match()}}.}

\item{ott_rank}{A character vector with the ranks you wanna get lineage children from.}
}
\value{
A list of named numeric vectors with OTT ids from input and all requested ranks.
}
\description{
Get the Open Tree of Life Taxonomic identifiers (OTT ids) and name of one or
several given taxonomic ranks from one or more input taxa.
}
