% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_ext.R
\name{read_text}
\alias{read_text}
\alias{read_asp}
\alias{read_spa}
\alias{read_spc}
\alias{read_jdx}
\alias{read_extdata}
\title{Read spectral data}
\usage{
read_text(
  file,
  colnames = NULL,
  method = "fread",
  metadata = list(file_name = basename(file), user_name = NULL, contact_info = NULL,
    organization = NULL, citation = NULL, spectrum_type = NULL, spectrum_identity = NULL,
    material_form = NULL, material_phase = NULL, material_producer = NULL,
    material_purity = NULL, material_quality = NULL, material_color = NULL,
    material_other = NULL, cas_number = NULL, instrument_used = NULL,
    instrument_accessories = NULL, instrument_mode = NULL, spectral_resolution = NULL,
    laser_light_used = NULL, number_of_accumulations = NULL, 
    
    total_acquisition_time_s = NULL, data_processing_procedure = NULL,
    level_of_confidence_in_identification = NULL, other_info = NULL, license =
    "CC BY-NC"),
  ...
)

read_asp(
  file,
  metadata = list(file_name = basename(file), user_name = NULL, contact_info = NULL,
    organization = NULL, citation = NULL, spectrum_type = NULL, spectrum_identity = NULL,
    material_form = NULL, material_phase = NULL, material_producer = NULL,
    material_purity = NULL, material_quality = NULL, material_color = NULL,
    material_other = NULL, cas_number = NULL, instrument_used = NULL,
    instrument_accessories = NULL, instrument_mode = NULL, spectral_resolution = NULL,
    laser_light_used = NULL, number_of_accumulations = NULL, 
    
    total_acquisition_time_s = NULL, data_processing_procedure = NULL,
    level_of_confidence_in_identification = NULL, other_info = NULL, license =
    "CC BY-NC"),
  ...
)

read_spa(
  file,
  metadata = list(file_name = basename(file), user_name = NULL, contact_info = NULL,
    organization = NULL, citation = NULL, spectrum_type = NULL, spectrum_identity = NULL,
    material_form = NULL, material_phase = NULL, material_producer = NULL,
    material_purity = NULL, material_quality = NULL, material_color = NULL,
    material_other = NULL, cas_number = NULL, instrument_used = NULL,
    instrument_accessories = NULL, instrument_mode = NULL, spectral_resolution = NULL,
    laser_light_used = NULL, number_of_accumulations = NULL, 
    
    total_acquisition_time_s = NULL, data_processing_procedure = NULL,
    level_of_confidence_in_identification = NULL, other_info = NULL, license =
    "CC BY-NC"),
  ...
)

read_spc(
  file,
  metadata = list(file_name = basename(file), user_name = NULL, contact_info = NULL,
    organization = NULL, citation = NULL, spectrum_type = NULL, spectrum_identity = NULL,
    material_form = NULL, material_phase = NULL, material_producer = NULL,
    material_purity = NULL, material_quality = NULL, material_color = NULL,
    material_other = NULL, cas_number = NULL, instrument_used = NULL,
    instrument_accessories = NULL, instrument_mode = NULL, spectral_resolution = NULL,
    laser_light_used = NULL, number_of_accumulations = NULL, 
    
    total_acquisition_time_s = NULL, data_processing_procedure = NULL,
    level_of_confidence_in_identification = NULL, other_info = NULL, license =
    "CC BY-NC"),
  ...
)

read_jdx(
  file,
  metadata = list(file_name = basename(file), user_name = NULL, contact_info = NULL,
    organization = NULL, citation = NULL, spectrum_type = NULL, spectrum_identity = NULL,
    material_form = NULL, material_phase = NULL, material_producer = NULL,
    material_purity = NULL, material_quality = NULL, material_color = NULL,
    material_other = NULL, cas_number = NULL, instrument_used = NULL,
    instrument_accessories = NULL, instrument_mode = NULL, spectral_resolution = NULL,
    laser_light_used = NULL, number_of_accumulations = NULL, 
    
    total_acquisition_time_s = NULL, data_processing_procedure = NULL,
    level_of_confidence_in_identification = NULL, other_info = NULL, license =
    "CC BY-NC"),
  ...
)

read_extdata(file = NULL)
}
\arguments{
\item{file}{file to be read from or written to.}

\item{colnames}{character vector of \code{length = 2} indicating the column
names for the wavenumber and intensity; if \code{NULL} columns are guessed.}

\item{method}{submethod to be used for reading text files; defaults to
\code{\link[data.table]{fread}()} but \code{\link[utils]{read.csv}()} works
as well.}

\item{metadata}{a named list of the metadata; see
\code{\link{as_OpenSpecy}()} for details.}

\item{\ldots}{further arguments passed to the submethods.}
}
\value{
All \code{read_*()} functions return data frames containing two columns
named \code{"wavenumber"} and \code{"intensity"}.
}
\description{
Functions for reading spectral data from external file types.
Currently supported reading formats are .csv and other text files, .asp,
.spa, .spc, .xyz, and .jdx.
Additionally, .0 (OPUS) and .dat (ENVI) files are supported via
\code{\link{read_opus}()} and \code{\link{read_envi}()}, respectively.
\code{\link{read_zip}()} takes any of the files listed above.
Note that proprietary file formats like .0, .asp, and .spa are poorly
supported but will likely still work in most cases.
}
\details{
\code{read_spc()} and \code{read_jdx()} are wrappers around the
functions provided by the \link[hyperSpec:hyperSpec-package]{hyperSpec}.
Other functions have been adapted various online sources.
Metadata is harvested if possible.
There are many unique iterations of spectral file formats so there may be
bugs in the file conversion. Please contact us if you identify any.
}
\examples{
read_extdata("raman_hdpe.csv") |> read_text()
read_extdata("raman_atacamit.spc") |> read_spc()
read_extdata("ftir_ldpe_soil.asp") |> read_asp()
read_extdata("testdata_zipped.zip") |> read_zip()

}
\seealso{
\code{\link{read_spec}()} for reading .y(a)ml, .json, or .rds (OpenSpecy)
files;
\code{\link{read_opus}()} for reading .0 (OPUS) files;
\code{\link{read_envi}()} for reading .dat (ENVI) files;
\code{\link{read_zip}()} and \code{\link{read_any}()} for wrapper functions;
\code{\link[hyperSpec]{read.jdx}()}; \code{\link[hyperSpec]{read.spc}()}
}
\author{
Zacharias Steinmetz, Win Cowger
}
