% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{summary.Subcascades}
\alias{summary.Subcascades}
\title{Summary Subcascades Characteristics}
\usage{
\method{summary}{Subcascades}(object = NULL, digits = 3, ...)
}
\arguments{
\item{object}{A Subcascades object as it is returned by \code{\link{subcascades}}-function.
The Subcascades object is made up of a list of matrices.
Each matrix comprises the evaluation results of cascades of a specific length and
is sorted row-wise according to the achieved minimal classwise sensitivities of the cascades (decreasing).
The rownames show the class order by a character string of type '1>2>3' and the entries the sensitivity for each position of the cascade.}

\item{digits}{Integer defining the number of decimal places as it is used in the \code{round}-function.}

\item{...}{Further arguments passed from other methods.}
}
\value{
An invisible Subcascades object as it is returned by \code{\link{subcascades}}-function.
The function is called to print a summary of the Subcascades object to console.
}
\description{
Generates a general overview of the characteristics of the Subcascades object.
}
\details{
This function gives a general overview of characteristics of the Subcascades object, like number of cascades or maximal cascade length.
}
\examples{
library(TunePareto)
data(esl)
data <- esl$data
labels <- esl$labels
foldList <- generateCVRuns(labels  = labels,
                          ntimes      = 2,
                          nfold       = 2,
                          leaveOneOut = FALSE,
                          stratified  = TRUE)
genMap <- gen.predictionMap(data, labels, foldList = foldList, 
classifier = tunePareto.svm(), kernel='linear')
# generate Subcascades object
subcascades <- subcascades(genMap,thresh=0.7,numSol=10000)

summary(subcascades)

}
\seealso{
\code{\link{subcascades}}, \code{\link{summarySubcascades}}, \code{\link{summaryGroupwise}}, \code{\link{summaryClasses}}
}
