% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/groupwise.R
\name{groupwise}
\alias{groupwise}
\title{Coerce to a Groupwise object}
\usage{
groupwise(subcascades = NULL, maxCl = 50)
}
\arguments{
\item{subcascades}{A Subcascades object as it is returned by \code{\link{subcascades}}-function.
The Subcascades object is made up of a list of matrices. 
Each matrix comprises the evaluation results of cascades of a specific length and 
is sorted row-wise according to the achieved minimal classwise sensitivities of the cascades (decreasing).
The rownames show the class order by a character string of type '1>2>3' and the entries the sensitivity for each position of the cascade.}

\item{maxCl}{An integer defining the lower bound for the maximal number of classes. Has only to be set if the analyzed dataset has more than 50 classes.}
}
\value{
A Groupwise object, which comprises a two-leveled list. The first level collects cascades of the same size.
The second level contains a list of unique class combinations, labelled as a character string with '-' separating the different classes. 
For each unique set of class combinations the corresponding orders and their performance are given as a matrix, 
where each row contains a cascade, given as a character string of type '1>2>3', and the columns the sensitivity for the class at the corresponding position.
Each matrix is sorted row-wise according to the achieved minimal classwise sensitivites of the cascades (decreasing).
}
\description{
Converts from a Subcascades object to a Groupwise object.
}
\details{
This function re-sorts the Subcascades object in a way that the cascades made up of the same classes are grouped.
}
\examples{

library(TunePareto)
data(esl)
data = esl$data
labels = esl$labels
foldList = generateCVRuns(labels  = labels,
                          ntimes      = 2,
                          nfold       = 2,
                          leaveOneOut = FALSE,
                          stratified  = TRUE)
predMap = predictionMap(data, labels, foldList = foldList, 
                       classifier = tunePareto.svm(), kernel='linear')
# generate Subcascades object
subcascades = subcascades(predMap,thresh=0.7)

#create a Groupwise object
groupwise = groupwise(subcascades)
}
\seealso{
\code{\link{as.subcascades}}, \code{\link{summary.Groupwise}}, \code{\link{print.Groupwise}}, \code{\link{plot.Groupwise}}, \code{\link{as.edgedataframe}}
}
